package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class OptionsListWidget extends AbstractListWidget<OptionsListWidget.AbstractEntry> {
    private static final int BACKGROUND_PADDING_Y = 2;
    private static final int SEARCH_HIGHLIGHT_COLOR = 0x66FFD700; // 40% yellow
    private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF); // 15% white
    private final class_327 font;
    private @NotNull String search = "";

    public OptionsListWidget(class_310 minecraft, class_327 font, int itemHeight, int spacing) {
        super(minecraft, 0, 0, 0, itemHeight, spacing);

        this.font = font;
    }

    public OptionsListWidget(class_310 minecraft, class_327 font, int spacing) {
        this(minecraft, font, class_4185.field_39501, spacing);
    }

    public void addWidget(class_339 widget) {
        this.method_25321(new WidgetEntry(widget));
    }

    public void addToggle(
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable class_7919 tooltip,
            boolean active
    ) {
        this.method_25321(new ToggleEntry(value, onToggle, label, null, tooltip, active));
    }

    public void addToggle(
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable Prefix prefix,
            @Nullable class_7919 tooltip,
            boolean active
    ) {
        this.method_25321(new ToggleEntry(value, onToggle, label, prefix, tooltip, active));
    }

    public void addToggleableSlider(
            @NotNull SliderWidget slider,
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @Nullable class_7919 tooltip
    ) {
        this.method_25321(new ToggleableSliderEntry(slider, value, onToggle, tooltip, true));
    }

    public void search(@NotNull String search) {
        this.search = search.toLowerCase();

        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.method_25396()) {
                if (entry.indexedLabel.contains(this.search)) {
                    this.method_25328(entry);
                    break;
                }
            }
        }
    }

    private int computeBackgroundX(AbstractEntry entry) {
        return entry.getX() - this.rowGap;
    }

    private int computeBackgroundY(AbstractEntry entry) {
        return entry.getY() - BACKGROUND_PADDING_Y;
    }

    private int computeBackgroundWidth(AbstractEntry entry) {
        return entry.getWidth() + this.rowGap + (this.method_44392() ? field_55258 : BACKGROUND_PADDING_Y);
    }

    private int computeBackgroundHeight(AbstractEntry entry) {
        return entry.getHeight() + BACKGROUND_PADDING_Y * 2;
    }

    protected void renderSearchBackground(@NotNull class_332 guiGraphics) {
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.method_25396()) {
                if (entry.indexedLabel.contains(this.search)) {
                    int bgX = this.computeBackgroundX(entry);
                    int bgY = this.computeBackgroundY(entry);
                    int bgWidth = this.computeBackgroundWidth(entry);
                    int bgHeight = this.computeBackgroundHeight(entry);

                    guiGraphics.method_25294(bgX, bgY, bgX + bgWidth, bgY + bgHeight, SEARCH_HIGHLIGHT_COLOR);
                }
            }
        }
    }

    protected void renderEntryBackground(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int minX = this.method_46426() - this.rowGap;
        int minY = this.method_46427() - BACKGROUND_PADDING_Y;
        int maxX = this.method_55442() + field_55258;
        int maxY = this.method_55443() + BACKGROUND_PADDING_Y;
        guiGraphics.method_44379(minX, minY, maxX, maxY);

        this.renderSearchBackground(guiGraphics);

        AbstractEntry entry = this.method_25308(mouseX, mouseY);
        if (entry == null) {
            this.hoveredBackground.reset();
        } else {
            int x = this.computeBackgroundX(entry);
            int y = this.computeBackgroundY(entry);
            int width = this.computeBackgroundWidth(entry);
            int height = this.computeBackgroundHeight(entry);
            this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
        }

        guiGraphics.method_44380();
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderEntryBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void method_57715(@NotNull class_332 guiGraphics) {
        // remove background
    }

    @Override
    protected void method_57713(@NotNull class_332 guiGraphics) {
        // remove separators
    }

    protected abstract class AbstractEntry extends AbstractListWidget<AbstractEntry>.Entry {
        protected final class_2561 label;
        private final String indexedLabel;
        private final List<class_339> children = new ArrayList<>();

        protected AbstractEntry(class_2561 label) {
            this.label = label;
            this.indexedLabel = label.getString().toLowerCase();
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            for (class_339 child : this.children) {
                child.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        protected <T extends class_339> T addChild(T child) {
            this.children.add(child);
            return child;
        }

        @Override
        public @NotNull List<class_339> method_25396() {
            return this.children;
        }

        @Override
        public @NotNull List<class_339> method_37025() {
            return this.children;
        }
    }

    private class WidgetEntry extends AbstractEntry {
        private final class_339 widget;

        private WidgetEntry(@NotNull class_339 widget) {
            super(widget.method_25369());

            this.widget = this.addChild(widget);
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.widget.method_55445(width, height - OptionsListWidget.this.rowGap);
            this.widget.method_48229(left, top);
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    private class ToggleEntry extends AbstractEntry {
        protected static final int BUTTON_WIDTH = 40;
        private static final int LABEL_COLOR = 0xFFFFFFFF; // white
        private static final int DISABLED_COLOR = 0xFFAAAAAA; // gray
        private final ButtonWidget button;
        private final Consumer<Boolean> onToggle;
        private final @Nullable Prefix prefix;
        protected boolean value;

        private ToggleEntry(
                boolean value,
                @NotNull Consumer<Boolean> onToggle,
                @NotNull class_2561 label,
                @Nullable Prefix prefix,
                @Nullable class_7919 tooltip,
                boolean active
        ) {
            super(label);

            this.value = value;
            this.onToggle = onToggle;
            this.button = new ButtonWidget(
                    this.getRight() - BUTTON_WIDTH,
                    this.getY(),
                    BUTTON_WIDTH,
                    class_4185.field_39501,
                    value ? class_5244.field_24332 : class_5244.field_24333,
                    this::onPress
            );
            this.button.method_47400(tooltip);
            this.button.field_22763 = active;
            this.prefix = prefix;

            this.addChild(this.button);
        }

        protected void onPress(class_4185 button) {
            this.value = !this.value;
            this.button.method_25355(this.value ? class_5244.field_24332 : class_5244.field_24333);
            this.onToggle.accept(this.value);
        }

        protected void renderLabel(@NotNull class_332 guiGraphics) {
            int marginX = 0;

            if (this.prefix != null) {
                marginX = this.prefix.render(guiGraphics, OptionsListWidget.this.font, this.getX(), this.getY(), this.getHeight());
                if (marginX > 0) marginX += OptionsListWidget.this.rowGap;
            }

            int startX = this.getX() + marginX;
            int startY = this.getY();
            int endX = this.button.method_46426() - OptionsListWidget.this.rowGap;
            int endY = this.getBottom();
            int color = this.value ? LABEL_COLOR : DISABLED_COLOR;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, OptionsListWidget.this.font, this.label, startX, startY, endX, endY, color);
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.button.method_48229(this.getRight() - this.button.method_25368(), top);

            this.renderLabel(guiGraphics);
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
        }
    }

    private class ToggleableSliderEntry extends ToggleEntry {
        private final SliderWidget slider;

        private ToggleableSliderEntry(
                @NotNull SliderWidget slider,
                boolean value,
                @NotNull Consumer<Boolean> onToggle,
                @Nullable class_7919 tooltip,
                boolean active
        ) {
            super(value, onToggle, slider.method_25369(), null, tooltip, active);

            this.slider = slider;
            this.slider.field_22763 = value;
            this.addChild(this.slider);
        }

        @Override
        protected void onPress(class_4185 button) {
            super.onPress(button);
            this.slider.field_22763 = this.value;
        }

        @Override
        protected void renderLabel(@NotNull class_332 guiGraphics) {
            // remove label
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);

            this.slider.method_25358(width - BUTTON_WIDTH - OptionsListWidget.this.rowGap);
            this.slider.method_48229(left, top);
            this.slider.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @FunctionalInterface
    public interface Prefix {
        /**
         * @return width of prefix
         */
        int render(@NotNull class_332 guiGraphics, class_327 font, int x, int y, int height);
    }
}