/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FabricMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"minecraft-cursor");
    private final String[] modsEarlyLoadingGLFW = new String[]{"earlyloadingscreen"};

    private boolean isGLFWEarlyLoaded() {
        for (String modId : this.modsEarlyLoadingGLFW) {
            if (!FabricLoader.getInstance().isModLoaded(modId)) continue;
            return true;
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        if (!this.isGLFWEarlyLoaded()) {
            return List.of("compat.glfw.GlfwMixin");
        }
        String infoLink = "https://github.com/fishstiz/minecraft-cursor/blob/mc/1.21.4/README.md#fabric-only-features";
        LOGGER.error("[minecraft-cursor] Fabric-only compatibility features could not be applied due to one of these mods: {}", (Object)this.modsEarlyLoadingGLFW);
        LOGGER.error("[minecraft-cursor] Learn more about the Fabric-only compatibility features: {}", (Object)infoLink);
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

