/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.config;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfigLoader;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CursorConfig
implements Serializable {
    private String _hash;
    private boolean itemSlotEnabled = true;
    private boolean itemGrabbingEnabled = true;
    private boolean creativeTabsEnabled = true;
    private boolean enchantmentsEnabled = true;
    private boolean stonecutterRecipesEnabled = true;
    private boolean bookEditEnabled = true;
    private boolean loomPatternsEnabled = true;
    private boolean advancementTabsEnabled = true;
    private boolean worldIconEnabled = true;
    private boolean serverIconEnabled = true;
    private boolean remapCursorsEnabled = true;
    private final GlobalSettings global = new GlobalSettings();
    private final Map<String, Settings> settings = new HashMap<String, Settings>();
    transient File file;

    CursorConfig() {
    }

    public Settings getOrCreateCursorSettings(CursorType type) {
        return this.settings.computeIfAbsent(type.getKey(), k -> new Settings());
    }

    public String get_hash() {
        if (this._hash == null) {
            this.generateHash();
        }
        return this._hash;
    }

    private void generateHash() {
        long hash = 0L;
        long prime = 31L;
        for (Map.Entry<String, Settings> entry : this.settings.entrySet()) {
            String key = entry.getKey();
            Settings value = entry.getValue();
            for (char c : key.toCharArray()) {
                hash = hash * prime + (long)c;
            }
            hash = hash * prime + (long)value.getScale();
            hash = hash * prime + (long)value.getXHot();
            hash = hash * prime + (long)value.getYHot();
            hash = hash * prime + (long)(value.isEnabled() ? 1 : 0);
        }
        this.set_hash(Long.toHexString(hash));
    }

    public void set_hash(String hash) {
        this._hash = hash;
    }

    public void save() {
        if (this.file == null) {
            throw new NullPointerException("Cannot save config when initialized without file.");
        }
        CursorConfigLoader.saveConfig(this.file, this);
    }

    public GlobalSettings getGlobal() {
        return this.global;
    }

    public Map<String, Settings> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Settings> settings) {
        this.settings.putAll(settings);
    }

    public boolean isCreativeTabsEnabled() {
        return this.creativeTabsEnabled;
    }

    public void setCreativeTabsEnabled(boolean creativeTabsEnabled) {
        this.creativeTabsEnabled = creativeTabsEnabled;
    }

    public boolean isEnchantmentsEnabled() {
        return this.enchantmentsEnabled;
    }

    public void setEnchantmentsEnabled(boolean enchantmentsEnabled) {
        this.enchantmentsEnabled = enchantmentsEnabled;
    }

    public boolean isStonecutterRecipesEnabled() {
        return this.stonecutterRecipesEnabled;
    }

    public void setStonecutterRecipesEnabled(boolean stonecutterRecipesEnabled) {
        this.stonecutterRecipesEnabled = stonecutterRecipesEnabled;
    }

    public boolean isBookEditEnabled() {
        return this.bookEditEnabled;
    }

    public void setBookEditEnabled(boolean bookEditEnabled) {
        this.bookEditEnabled = bookEditEnabled;
    }

    public boolean isLoomPatternsEnabled() {
        return this.loomPatternsEnabled;
    }

    public void setLoomPatternsEnabled(boolean loomPatternsEnabled) {
        this.loomPatternsEnabled = loomPatternsEnabled;
    }

    public boolean isWorldIconEnabled() {
        return this.worldIconEnabled;
    }

    public void setWorldIconEnabled(boolean worldIconEnabled) {
        this.worldIconEnabled = worldIconEnabled;
    }

    public boolean isItemSlotEnabled() {
        return this.itemSlotEnabled;
    }

    public void setItemSlotEnabled(boolean itemSlotEnabled) {
        this.itemSlotEnabled = itemSlotEnabled;
    }

    public boolean isItemGrabbingEnabled() {
        return this.itemGrabbingEnabled;
    }

    public void setItemGrabbingEnabled(boolean itemGrabbingEnabled) {
        this.itemGrabbingEnabled = itemGrabbingEnabled;
    }

    public boolean isAdvancementTabsEnabled() {
        return this.advancementTabsEnabled;
    }

    public void setAdvancementTabsEnabled(boolean advancementTabsEnabled) {
        this.advancementTabsEnabled = advancementTabsEnabled;
    }

    public boolean isServerIconEnabled() {
        return this.serverIconEnabled;
    }

    public void setServerIconEnabled(boolean serverIconEnabled) {
        this.serverIconEnabled = serverIconEnabled;
    }

    public boolean isRemapCursorsEnabled() {
        return this.remapCursorsEnabled;
    }

    public void setRemapCursorsEnabled(boolean remapCursorsEnabled) {
        this.remapCursorsEnabled = remapCursorsEnabled;
    }

    public static class GlobalSettings
    extends Settings {
        private boolean scaleActive = false;
        private boolean xhotActive = false;
        private boolean yhotActive = false;

        public void setActiveAll(boolean active) {
            this.setScaleActive(active);
            this.setXhotActive(active);
            this.setYhotActive(active);
        }

        public boolean isScaleActive() {
            return this.scaleActive;
        }

        public void setScaleActive(boolean scaleEnabled) {
            this.scaleActive = scaleEnabled;
        }

        public boolean isXHotActive() {
            return this.xhotActive;
        }

        public void setXhotActive(boolean xhotActive) {
            this.xhotActive = xhotActive;
        }

        public boolean isYHotActive() {
            return this.yhotActive;
        }

        public void setYhotActive(boolean yhotActive) {
            this.yhotActive = yhotActive;
        }

        public void setScale(double scale) {
            this.scale = SettingsUtil.sanitizeScale(scale);
        }

        public void setXHotDouble(double xhot) {
            this.setXHot((int)xhot);
        }

        public void setXHot(int xhot) {
            this.xhot = SettingsUtil.sanitizeHotspot(xhot);
        }

        public void setYHotDouble(double yhot) {
            this.setYHot((int)yhot);
        }

        public void setYHot(int yhot) {
            this.yhot = SettingsUtil.sanitizeHotspot(yhot);
        }
    }

    public static class Settings
    implements Serializable {
        protected double scale = 1.0;
        protected int xhot = 0;
        protected int yhot = 0;
        private boolean enabled = true;
        private Boolean animated;

        public void update(double scale, int xhot, int yhot, boolean enabled) {
            this.scale = SettingsUtil.sanitizeScale(scale);
            this.xhot = SettingsUtil.sanitizeHotspot(xhot);
            this.yhot = SettingsUtil.sanitizeHotspot(yhot);
            this.enabled = enabled;
        }

        public double getScale() {
            return SettingsUtil.sanitizeScale(this.scale);
        }

        public int getXHot() {
            return SettingsUtil.sanitizeHotspot(this.xhot);
        }

        public int getYHot() {
            return SettingsUtil.sanitizeHotspot(this.yhot);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Boolean isAnimated() {
            return this.animated;
        }

        public void setAnimated(boolean animated) {
            this.animated = animated;
        }

        public static class Default {
            public static final double SCALE = 1.0;
            public static final double SCALE_MIN = 0.5;
            public static final double SCALE_MAX = 3.0;
            public static final double SCALE_STEP = 0.05;
            public static final int X_HOT = 0;
            public static final int Y_HOT = 0;
            public static final int HOT_MIN = 0;
            public static final int HOT_MAX = 31;
            public static final boolean ENABLED = true;

            private Default() {
            }
        }
    }
}

