/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class CursorConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Gson GSON_ANIMATION = new GsonBuilder().registerTypeAdapter(AnimatedCursorConfig.Frame.class, (Object)new AnimatedCursorConfig.FrameDeserializer()).registerTypeAdapter(AnimationMode.class, (Object)new AnimationMode.Deserializer()).create();

    private CursorConfigLoader() {
    }

    public static AnimatedCursorConfig getAnimationConfig(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            AnimatedCursorConfig animatedCursorConfig = (AnimatedCursorConfig)GSON_ANIMATION.fromJson((Reader)reader, AnimatedCursorConfig.class);
            return animatedCursorConfig;
        }
    }

    public static CursorConfig fromStream(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            CursorConfig cursorConfig = (CursorConfig)GSON.fromJson((Reader)reader, CursorConfig.class);
            return cursorConfig;
        }
    }

    public static CursorConfig fromFile(File file) {
        if (!file.getPath().endsWith(".json")) {
            throw new IllegalArgumentException("Unsupported file type.");
        }
        CursorConfig config = new CursorConfig();
        try (FileReader reader = new FileReader(file);){
            config = (CursorConfig)GSON.fromJson((Reader)reader, CursorConfig.class);
        }
        catch (FileNotFoundException e) {
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Creating cursor config file at '{}'...", (Object)file.getPath());
            CursorConfigLoader.saveConfig(file, config);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.warn("[minecraft-cursor] Failed to load cursor config at '{}'", (Object)file.getPath());
        }
        config.file = file;
        return config;
    }

    public static void saveConfig(File file, CursorConfig config) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to save config file at '{}'", (Object)file.getPath());
        }
    }
}

