/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.util.BufferedImageUtil;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class Cursor {
    protected static final int SIZE = 32;
    protected final Consumer<Cursor> onLoad;
    private final CursorType type;
    private class_2960 sprite;
    private String cachedBufferedImage;
    private double scale;
    private int xhot;
    private int yhot;
    private boolean enabled;
    private boolean loaded;
    private int trueWidth;
    private int trueHeight;
    private long id = 0L;

    public Cursor(CursorType type, Consumer<Cursor> onLoad) {
        this.type = type;
        this.onLoad = onLoad;
    }

    public void loadImage(class_2960 sprite, BufferedImage image, CursorConfig.Settings settings) throws IOException {
        this.trueWidth = image.getWidth();
        this.trueHeight = image.getHeight();
        BufferedImage croppedImage = image;
        if (image.getWidth() > 32 || image.getHeight() > 32) {
            croppedImage = BufferedImageUtil.cropImage(croppedImage, new Rectangle(32, 32));
        }
        this.sprite = sprite;
        this.cachedBufferedImage = BufferedImageUtil.compressImageToBase64(croppedImage);
        this.enabled = settings.isEnabled();
        this.create(croppedImage, settings.getScale(), settings.getXHot(), settings.getYHot());
        croppedImage.flush();
    }

    protected void updateImage(double scale, int xhot, int yhot) {
        if (this.id == 0L) {
            return;
        }
        try {
            BufferedImage image = BufferedImageUtil.decompressBase64ToImage(this.cachedBufferedImage);
            this.create(image, SettingsUtil.sanitizeScale(scale), SettingsUtil.sanitizeHotspot(xhot), SettingsUtil.sanitizeHotspot(yhot));
            image.flush();
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("Error updating image of {}: {}", (Object)this.type, (Object)e);
        }
    }

    private void create(BufferedImage image, double scale, int xhot, int yhot) {
        BufferedImage scaledImage = scale == 1.0 ? image : BufferedImageUtil.scaleImage(image, scale);
        int scaledXHot = scale == 1.0 ? xhot : (int)Math.round((double)xhot * scale);
        int scaledYHot = scale == 1.0 ? yhot : (int)Math.round((double)yhot * scale);
        GLFWImage glfwImage = GLFWImage.create();
        glfwImage.width(scaledImage.getWidth());
        glfwImage.height(scaledImage.getHeight());
        glfwImage.pixels(BufferedImageUtil.getPixelsRGBA(scaledImage));
        scaledImage.flush();
        long previousId = this.id;
        ExternalCursorTracker.get().storeAddress(glfwImage.address());
        this.id = GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)scaledXHot, (int)scaledYHot);
        if (this.onLoad != null) {
            this.onLoad.accept(this);
        }
        if (previousId != 0L && this.id != previousId) {
            GLFW.glfwDestroyCursor((long)previousId);
        }
        this.loaded = true;
        this.scale = scale;
        this.xhot = xhot;
        this.yhot = yhot;
    }

    public void destroy() {
        if (this.id != 0L) {
            GLFW.glfwDestroyCursor((long)this.id);
        }
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
        if (this.onLoad != null) {
            this.onLoad.accept(this);
        }
    }

    public class_2960 getSprite() {
        return this.sprite;
    }

    public long getId() {
        return this.enabled ? this.id : 0L;
    }

    public CursorType getType() {
        return this.type;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.updateImage(scale, this.xhot, this.yhot);
    }

    public int getXHot() {
        return this.xhot;
    }

    public void setXHot(double xhot) {
        this.setXHot((int)xhot);
    }

    public void setXHot(int xhot) {
        this.updateImage(this.scale, xhot, this.yhot);
    }

    public int getYHot() {
        return this.yhot;
    }

    public void setYHot(double yhot) {
        this.setYHot((int)yhot);
    }

    public void setYHot(int yhot) {
        this.updateImage(this.scale, this.xhot, yhot);
    }

    public void setHotspots(int xhot, int yhot) {
        this.updateImage(this.scale, xhot, yhot);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getTrueWidth() {
        return this.trueWidth;
    }

    public int getTrueHeight() {
        return this.trueHeight;
    }
}

