package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.HandledScreenAccessor;
import net.minecraft.class_1718;
import net.minecraft.class_310;
import net.minecraft.class_486;
import net.minecraft.class_746;

public class EnchantmentScreenCursorHandler extends HandledScreenCursorHandler<class_1718, class_486> {
    // Derived from EnchantmentScreen#drawBackground
    public static final int ENCHANTMENT_BTN_WIDTH = 108;
    public static final int ENCHANTMENT_BTN_HEIGHT = 19;
    public static final int ENCHANTMENT_BTN_OFFSET_X = 60;
    public static final int ENCHANTMENT_BTN_OFFSET_Y = 14;

    @Override
    @SuppressWarnings("unchecked")
    public CursorType getCursorType(class_486 enchantmentScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(enchantmentScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT) return cursorType;

        if (!MinecraftCursor.CONFIG.isEnchantmentsEnabled()) return CursorType.DEFAULT;

        class_746 player = class_310.method_1551().field_1724;
        if (player == null) return CursorType.DEFAULT;

        HandledScreenAccessor<class_1718> accessor =
                (HandledScreenAccessor<class_1718>) enchantmentScreen;
        class_1718 handler = accessor.getHandler();

        for (int i = 0; i < handler.field_7808.length; i++) {
            int enchantmentPower = handler.field_7808[i];

            boolean isButtonEnabled = enchantmentPower != 0 &&
                    ((handler.method_7638() >= i + 1 && player.field_7520 >= enchantmentPower) ||
                            player.method_31549().field_7477);
            if (!isButtonEnabled) {
                continue;
            }

            int containerX = (enchantmentScreen.field_22789 - accessor.getBackgroundWidth()) / 2;
            int containerY = (enchantmentScreen.field_22790 - accessor.getBackgroundHeight()) / 2;
            int buttonX = containerX + ENCHANTMENT_BTN_OFFSET_X;
            int buttonY = containerY + ENCHANTMENT_BTN_OFFSET_Y + ENCHANTMENT_BTN_HEIGHT * i;
            int relativeX = (int) mouseX - buttonX;
            int relativeY = (int) mouseY - buttonY;

            if (relativeX >= 0
                    && relativeY >= 0
                    && relativeX < ENCHANTMENT_BTN_WIDTH
                    && relativeY < ENCHANTMENT_BTN_HEIGHT) {
                return CursorType.POINTER;
            }
        }
        return CursorType.DEFAULT;
    }
}
