package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_8132;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

public class CursorOptionsScreen extends class_437 {
    private static final class_2561 TITLE_TEXT = class_2561.method_43471("minecraft-cursor.options");
    private static final int CURSORS_COLUMN_WIDTH = 96;
    private static final int SELECTED_CURSOR_COLUMN_WIDTH = 200;
    private static final int COLUMN_GAP = 8;

    private final class_8132 layout = new class_8132(this);
    private final class_4185 moreButton = class_4185.method_46430(
            class_2561.method_43471("minecraft-cursor.options.more").method_27693("..."),
            btn -> toMoreOptions()).method_46431();
    private final class_4185 doneButton = class_4185.method_46430(
            class_5244.field_24334, btn -> this.method_25419()).method_46431();

    public final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private final CursorManager cursorManager;
    private final List<Cursor> cursors;
    final class_437 previousScreen;
    private Cursor selectedCursor;
    CursorOptionsBody body;

    public CursorOptionsScreen(class_437 previousScreen, CursorManager cursorManager) {
        super(TITLE_TEXT);

        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;

        cursors = this.cursorManager.getLoadedCursors();
    }

    @Override
    protected void method_25426() {
        selectedCursor = cursorManager.getLoadedCursors().get(0);

        this.layout.method_48992(new class_7842(this.field_22785, this.field_22793));
        this.body = this.layout.method_48999(new CursorOptionsBody());

        this.layout.method_48996(moreButton);
        this.layout.method_48996(doneButton);

        this.layout.method_48206(this::method_37063);
        this.method_37063(body.cursorsColumn);

        if (this.body != null) {
            this.refreshWidgetPositions();
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_25434(context);
        body.method_25394(context, mouseX, mouseY, delta);
        moreButton.method_25394(context, mouseX, mouseY, delta);
        doneButton.method_25394(context, mouseX, mouseY, delta);
    }

    protected void refreshWidgetPositions() {
        this.layout.method_48222();

        int bodyWidth = CURSORS_COLUMN_WIDTH + SELECTED_CURSOR_COLUMN_WIDTH + COLUMN_GAP;
        int buttonWidth = bodyWidth / 2 - COLUMN_GAP / 2;
        int centerX = field_22789 / 2;
        int gapHalf = COLUMN_GAP / 2;

        moreButton.method_25358(buttonWidth);
        doneButton.method_25358(buttonWidth - 2);

        moreButton.method_46421(centerX - buttonWidth - gapHalf);
        doneButton.method_46421(centerX + gapHalf);

        body.position();
    }

    public void selectCursor(Cursor cursor) {
        updateSelectedCursorConfig();
        selectedCursor = cursor;

        if (body != null) {
            body.selectedCursorColumn.refresh();
        }
    }

    private void updateSelectedCursorConfig() {
        if (body != null) {
            body.selectedCursorColumn.save();
        }
    }

    public Cursor getSelectedCursor() {
        return selectedCursor;
    }

    public List<Cursor> getCursors() {
        return cursors;
    }

    public void toMoreOptions() {
        if (field_22787 != null) {
            field_22787.method_1507(new MoreOptionsScreen(this, cursorManager));
        }
    }

    @Override
    public void method_25419() {
        CursorOptionsHandler.removeScaleOverride();
        CONFIG.save();

        if (this.field_22787 != null) {
            this.field_22787.method_1507(previousScreen);
        }
    }

    public int getContentHeight() {
        return field_22790 - layout.method_48998() - layout.method_48994();
    }

    public class CursorOptionsBody extends ContainerWidget {
        public final CursorListWidget cursorsColumn;
        public final CursorOptionsWidget selectedCursorColumn;

        public CursorOptionsBody() {
            super(layout.method_46426(), layout.method_48998(), CursorOptionsScreen.this.field_22789, getContentHeight(), class_2561.method_43473());

            int y = layout.method_48998();
            int height = getContentHeight();
            var screen = CursorOptionsScreen.this;

            cursorsColumn = new CursorListWidget(field_22787, CURSORS_COLUMN_WIDTH, height, y, y + height, screen);
            selectedCursorColumn = new CursorOptionsWidget(computedX2(), SELECTED_CURSOR_COLUMN_WIDTH, height, y, screen);

            position();
        }

        @Override
        public boolean method_25401(double mouseX, double mouseY, double amount) {
            if (cursorsColumn.method_25405(mouseX, mouseY)) {
                return cursorsColumn.method_25401(mouseX, mouseY, amount);
            }
            return super.method_25401(mouseX, mouseY, amount);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return List.of(cursorsColumn, selectedCursorColumn);
        }

        @Override
        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            cursorsColumn.method_25394(context, mouseX, mouseY, delta);
            selectedCursorColumn.method_25394(context, mouseX, mouseY, delta);
        }

        public void position() {
            int width = CursorOptionsScreen.this.field_22789;
            int height = method_44391();
            int y = layout.method_48998();

            this.setDimensions(width, height);
            this.method_48229(0, y);

            cursorsColumn.setHeight(height);
            selectedCursorColumn.setHeight(height);

            cursorsColumn.method_25333(computedX());
            selectedCursorColumn.method_46421(computedX2());
        }

        private int computedX() {
            return CursorOptionsScreen.this.field_22789 / 2 - (CURSORS_COLUMN_WIDTH + SELECTED_CURSOR_COLUMN_WIDTH + COLUMN_GAP) / 2;
        }

        private int computedX2() {
            return computedX() + CURSORS_COLUMN_WIDTH + COLUMN_GAP;
        }

        public void setDimensions(int width, int height) {
            this.field_22758 = width;
            this.field_22759 = height;
        }

        @Override
        protected void method_47399(class_6382 builder) {
            // not supported
        }

        @Override
        protected int method_44391() {
            return getContentHeight();
        }

        @Override
        protected double method_44393() {
            return 0;
        }

        @Override
        protected void method_44389(class_332 context, int mouseX, int mouseY, float delta) {
            this.method_25394(context, mouseX, mouseY, delta);
        }
    }
}
