package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.*;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;
import static io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget.*;

public class MoreOptionsListWidget extends class_4265<MoreOptionsListWidget.OptionEntry> implements class_8021 {
    private static final CursorConfig.GlobalSettings GLOBAL = CONFIG.getGlobal();

    private static final String GLOBAL_TOOLTIP_KEY = "minecraft-cursor.options.more.global.tooltip";
    private static final class_2561 GLOBAL_SETTINGS_TEXT = class_2561.method_43471("minecraft-cursor.options.more.global");

    private static final class_7919 ANIMATION_TOOLTIP = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.more.animation.tooltip"));
    private static final class_2561 ANIMATION_TEXT = class_2561.method_43471("minecraft-cursor.options.more.animation");

    private static final class_7919 ADAPTIVE_CURSOR_TOOLTIP = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.more.adapt.tooltip"));
    private static final class_2561 ADAPTIVE_CURSOR_TEXT = class_2561.method_43471("minecraft-cursor.options.more.adapt");
    private static final class_2561 ITEM_SLOT_TEXT = class_2561.method_43471("minecraft-cursor.options.item_slot");
    private static final class_2561 ITEM_GRAB_TEXT = class_2561.method_43471("minecraft-cursor.options.item_grab");
    private static final class_2561 CREATIVE_TABS_TEXT = class_2561.method_43471("minecraft-cursor.options.creative_tabs");
    private static final class_2561 ENCHANTMENTS_TEXT = class_2561.method_43471("minecraft-cursor.options.enchantments");
    private static final class_2561 STONECUTTER_TEXT = class_2561.method_43471("minecraft-cursor.options.stonecutter");
    private static final class_2561 BOOK_EDIT_TEXT = class_2561.method_43471("minecraft-cursor.options.book_edit");
    private static final class_2561 LOOM_TEXT = class_2561.method_43471("minecraft-cursor.options.loom");
    private static final class_2561 ADVANCEMENTS_TEXT = class_2561.method_43471("minecraft-cursor.options.advancements");
    private static final class_2561 WORLD_ICON_TEXT = class_2561.method_43471("minecraft-cursor.options.world");
    private static final class_2561 SERVER_ICON_TEXT = class_2561.method_43471("minecraft-cursor.options.server");

    private static final class_2561 RESOURCE_TEXT = class_2561.method_43471("minecraft-cursor.options.more.resource_pack");
    private static final class_2561 RESOURCE_RELOAD_TEXT = class_2561.method_43471("minecraft-cursor.options.more.resource_pack.reset");
    private static final class_2561 RESOURCE_RELOAD_TOOLTIP_TEXT = class_2561.method_43471("minecraft-cursor.options.more.resource_pack.reset.tooltip");

    private static final class_2561 COMPAT_TEXT = class_2561.method_43471("minecraft-cursor.options.more.compat");
    private static final class_2561 REMAP_TEXT = class_2561.method_43471("minecraft-cursor.options.more.compat.remap_cursors");
    private static final class_7919 REMAP_TOOLTIP = class_7919.method_47407(class_2561.method_43471("minecraft-cursor.options.more.compat.remap_cursors.tooltip"));

    private static final int BUTTON_WIDTH = 40;
    private static final int ITEM_HEIGHT = 20;
    private static final int ROW_GAP = 6;

    private final CursorManager cursorManager;
    private final List<ToggleEntry> adaptiveOptions = new ArrayList<>();

    private final ToggleEntry animationEntry = new ToggleEntry(
            ANIMATION_TEXT, false, false, ANIMATION_TOOLTIP, this::toggleAnimations
    );
    private final SliderEntry scaleEntry = createSliderEntry(SCALE_TEXT, "",
            CursorConfig.Settings.Default.SCALE_MIN, CursorConfig.Settings.Default.SCALE_MAX, CursorConfig.Settings.Default.SCALE_STEP,
            GLOBAL::isScaleActive, GLOBAL::setScaleActive,
            GLOBAL::getScale, GLOBAL::setScale,
            CursorConfig.Settings::getScale, Cursor::setScale
    );
    private final SliderEntry xhotEntry = createSliderEntry(XHOT_TEXT, "px",
            CursorConfig.Settings.Default.HOT_MIN, CursorConfig.Settings.Default.HOT_MAX, 1,
            GLOBAL::isXHotActive, GLOBAL::setXhotActive,
            GLOBAL::getXHot, GLOBAL::setXHotDouble,
            CursorConfig.Settings::getXHot, Cursor::setXHot
    );
    private final SliderEntry yhotEntry = createSliderEntry(YHOT_TEXT, "px",
            CursorConfig.Settings.Default.HOT_MIN, CursorConfig.Settings.Default.HOT_MAX, 1,
            GLOBAL::isYHotActive, GLOBAL::setYhotActive,
            GLOBAL::getYHot, GLOBAL::setYHotDouble,
            CursorConfig.Settings::getYHot, Cursor::setYHot
    );
    private int y;

    public MoreOptionsListWidget(class_310 minecraftClient, int width, int height, int y, int bottom, CursorManager cursorManager) {
        super(minecraftClient, width, height, y, bottom, ITEM_HEIGHT + ROW_GAP);

        this.cursorManager = cursorManager;
        this.y = y;

        addGlobalOptions();
        addAdaptiveOptions();
        addModCompatOptions();
        addResourcePackOptions();
    }

    private void addGlobalOptions() {
        method_25321(new TitleEntry(GLOBAL_SETTINGS_TEXT));

        reloadGlobalOptions();
        method_25321(animationEntry);
        method_25321(scaleEntry);
        method_25321(xhotEntry);
        method_25321(yhotEntry);
    }

    private void reloadGlobalOptions() {
        try {
            animationEntry.button.setValue(cursorManager.isAnimated());
            animationEntry.button.field_22763 = cursorManager.hasAnimations();
            scaleEntry.button.setValue(GLOBAL.isScaleActive());
            xhotEntry.button.setValue(GLOBAL.isXHotActive());
            yhotEntry.button.setValue(GLOBAL.isYHotActive());
        } catch (NullPointerException ignore) { // when exiting the screen while reloading
        }
    }

    private void addAdaptiveOptions() {
        boolean isAdaptive = cursorManager.isAdaptive();
        method_25321(new TitleEntry(ADAPTIVE_CURSOR_TEXT));
        method_25321(new ToggleEntry(ENABLED_TEXT, isAdaptive, true, ADAPTIVE_CURSOR_TOOLTIP, this::toggleAdaptive));
        addAdaptiveEntry(ITEM_SLOT_TEXT, CONFIG.isItemSlotEnabled(), isAdaptive, CONFIG::setItemSlotEnabled);
        addAdaptiveEntry(ITEM_GRAB_TEXT, CONFIG.isItemGrabbingEnabled(), isAdaptive, CONFIG::setItemGrabbingEnabled);
        addAdaptiveEntry(CREATIVE_TABS_TEXT, CONFIG.isCreativeTabsEnabled(), isAdaptive, CONFIG::setCreativeTabsEnabled);
        addAdaptiveEntry(ENCHANTMENTS_TEXT, CONFIG.isEnchantmentsEnabled(), isAdaptive, CONFIG::setEnchantmentsEnabled);
        addAdaptiveEntry(STONECUTTER_TEXT, CONFIG.isStonecutterRecipesEnabled(), isAdaptive, CONFIG::setStonecutterRecipesEnabled);
        addAdaptiveEntry(BOOK_EDIT_TEXT, CONFIG.isBookEditEnabled(), isAdaptive, CONFIG::setBookEditEnabled);
        addAdaptiveEntry(LOOM_TEXT, CONFIG.isLoomPatternsEnabled(), isAdaptive, CONFIG::setLoomPatternsEnabled);
        addAdaptiveEntry(ADVANCEMENTS_TEXT, CONFIG.isAdvancementTabsEnabled(), isAdaptive, CONFIG::setAdvancementTabsEnabled);
        addAdaptiveEntry(WORLD_ICON_TEXT, CONFIG.isWorldIconEnabled(), isAdaptive, CONFIG::setWorldIconEnabled);
        addAdaptiveEntry(SERVER_ICON_TEXT, CONFIG.isServerIconEnabled(), isAdaptive, CONFIG::setServerIconEnabled);
    }

    private void addModCompatOptions() {
        method_25321(new TitleEntry(COMPAT_TEXT));
        method_25321(new ToggleEntry(REMAP_TEXT, CONFIG.isRemapCursorsEnabled(), true, REMAP_TOOLTIP, CONFIG::setRemapCursorsEnabled));
    }

    private void addResourcePackOptions() {
        method_25321(new TitleEntry(RESOURCE_TEXT));
        method_25321(new FullButtonEntry(RESOURCE_RELOAD_TEXT, RESOURCE_RELOAD_TOOLTIP_TEXT, this::reloadConfiguration));
    }

    private void reloadConfiguration() {
        CONFIG.set_hash(String.valueOf(Math.random()));
        field_22740.method_1521().thenRun(this::reloadGlobalOptions);
    }

    private void addAdaptiveEntry(class_2561 label, boolean isEnabled, boolean active, Consumer<Boolean> onPress) {
        ToggleEntry entry = new ToggleEntry(label, isEnabled, active, onPress);
        adaptiveOptions.add(entry);
        this.method_25321(entry);
    }

    private SliderEntry createSliderEntry(
            class_2561 text, String suffix,
            double min, double max, double step,
            BooleanSupplier activeGetter,
            BooleanConsumer activeSetter,
            DoubleSupplier valueGetter,
            DoubleConsumer valueSetter,
            ToDoubleFunction<CursorConfig.Settings> settingsValueGetter,
            ObjDoubleConsumer<Cursor> cursorAction
    ) {
        Runnable updateCursors = () -> cursorManager.getLoadedCursors().forEach(cursor -> {
            double value = activeGetter.getAsBoolean()
                    ? valueGetter.getAsDouble()
                    : settingsValueGetter.applyAsDouble(CONFIG.getOrCreateCursorSettings(cursor.getType()));
            cursorAction.accept(cursor, value);
        });
        DoubleConsumer handleChange = value -> {
            valueSetter.accept(value);
            cursorAction.accept(cursorManager.getCurrentCursor(), value);
        };
        BooleanConsumer handleToggle = active -> {
            activeSetter.accept(active);
            updateCursors.run();
        };

        var slider = new SliderEntry.Slider(text, suffix, valueGetter.getAsDouble(), min, max, step, handleChange::accept);
        var toggle = new SliderEntry.Toggle(ENABLED_TEXT, activeGetter.getAsBoolean(), getSettingTooltip(text), handleToggle);
        return new SliderEntry(slider, toggle, updateCursors);
    }

    public void handleChangeHotspotWidget(MouseEvent mouseEvent, int xhot, int yhot) {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();

        if (applyX) {
            GLOBAL.setXHot(xhot);
            xhotEntry.sliderWidget.setTranslatedValue(xhot);
        }
        if (applyY) {
            GLOBAL.setYHot(yhot);
            yhotEntry.sliderWidget.setTranslatedValue(yhot);
        }

        if (applyX && applyY) {
            cursorManager.getCurrentCursor().setHotspots(xhot, yhot);
        } else if (applyX) {
            cursorManager.getCurrentCursor().setXHot(xhot);
        } else if (applyY) {
            cursorManager.getCurrentCursor().setYHot(yhot);
        }

        if (mouseEvent == MouseEvent.RELEASE) {
            applyHotspotsToAll();
        }
    }

    private void applyHotspotsToAll() {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();

        if (applyX && applyY) {
            cursorManager.getLoadedCursors().forEach(cursor -> cursor.setHotspots(GLOBAL.getXHot(), GLOBAL.getYHot()));
        } else if (applyX) {
            cursorManager.getLoadedCursors().forEach(cursor -> cursor.setXHot(GLOBAL.getXHot()));
        } else if (applyY) {
            cursorManager.getLoadedCursors().forEach(cursor -> cursor.setYHot(GLOBAL.getYHot()));
        }
    }

    private void applyScaleToAll() {
        if (GLOBAL.isScaleActive()) {
            cursorManager.getLoadedCursors().forEach(cursor -> cursor.setScale(GLOBAL.getScale()));
        }
    }

    // in case the user escapes the screen before releasing slider.
    public void applyConfig() {
        applyScaleToAll();
        applyHotspotsToAll();
    }

    private void toggleAnimations(boolean isAnimated) {
        cursorManager.setIsAnimated(isAnimated);

        CONFIG.getSettings().forEach((key, settings) -> {
            if (cursorManager.getCursor(key) instanceof AnimatedCursor) {
                settings.setAnimated(isAnimated);
            }
        });
    }

    private void toggleAdaptive(boolean isEnabled) {
        adaptiveOptions.forEach(option -> {
            option.button.field_22763 = isEnabled;
            option.button.setValue(isEnabled);
        });

        cursorManager.setIsAdaptive(isEnabled);

        CONFIG.getSettings().forEach((key, settings) -> {
            if (key.equals(CursorType.DEFAULT.getKey())) return;

            settings.update(
                    settings.getScale(),
                    settings.getXHot(),
                    settings.getYHot(),
                    isEnabled
            );
        });
    }

    public int getYEntry(int index) {
        return method_46427() + field_22741 * index + ROW_GAP - (int) Math.round(method_25341());
    }

    public int getRowGap() {
        return ROW_GAP;
    }

    public boolean isEditingHotspot() {
        return (GLOBAL.isXHotActive() || GLOBAL.isYHotActive()) && (xhotEntry.isFocused() || yhotEntry.isFocused());
    }

    public ToggleWidget createToggleWidget(boolean defaultValue, class_7919 tooltip, Consumer<Boolean> onPress) {
        return new ToggleWidget(
                method_31383() - BUTTON_WIDTH,
                method_46427() + field_22741 * method_25340() + ROW_GAP,
                BUTTON_WIDTH,
                field_22741 - ROW_GAP,
                defaultValue,
                tooltip,
                onPress
        );
    }

    public static class_7919 getSettingTooltip(class_2561 settingText) {
        return class_7919.method_47407(class_2561.method_43469(GLOBAL_TOOLTIP_KEY, settingText));
    }

    public void position(int width, int height, int y) {
        this.field_22742 = width;
        this.field_22743 = height;
        this.method_25333(0);
        this.field_19085 = y;
    }


    @Override
    public void method_46421(int x) {
        this.method_25333(x);
    }

    @Override
    public void method_46419(int y) {
        // unsupported
    }

    @Override
    public int method_46426() {
        return method_25342();
    }

    @Override
    public int method_46427() {
        return y;
    }

    @Override
    public int method_25368() {
        return this.method_25322();
    }

    @Override
    public int method_25364() {
        return this.field_22741;
    }

    @Override
    public void method_48206(Consumer<class_339> consumer) {
        // unsupported
    }

    public abstract static class OptionEntry extends Entry<OptionEntry> {
        protected final class_2561 label;

        protected OptionEntry(class_2561 label) {
            this.label = label;
        }

        @Override
        public List<? extends class_6379> narratables() {
            return getChildren();
        }

        @Override
        public List<? extends class_364> children() {
            return getChildren();
        }

        protected abstract List<class_339> getChildren();
    }

    public class LabeledButtonEntry<T extends class_339> extends OptionEntry {
        protected final T button;

        protected LabeledButtonEntry(class_2561 label, Supplier<T> buttonFactory) {
            super(label);

            this.button = buttonFactory.get();
            this.button.method_25358(BUTTON_WIDTH);
            this.button.field_22759 = 20;
        }

        @Override
        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            button.method_46421(method_31383() - BUTTON_WIDTH);
            button.method_46419(getYEntry(index));
            button.method_25394(context, mouseX, mouseY, tickDelta);

            int textEndX = button.method_46426() - ROW_GAP;
            int textEndY = y + entryHeight;
            int textColor = 0xFFFFFFFF; // white
            DrawUtil.drawScrollableTextLeftAlign(context, field_22740.field_1772, label, x, y, textEndX, textEndY, textColor);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(button);
        }
    }

    public static class ToggleWidget extends SelectedCursorToggleWidget {
        protected ToggleWidget(
                int x, int y,
                int width, int height,
                boolean defaultValue,
                @Nullable class_7919 tooltip,
                Consumer<Boolean> onPress
        ) {
            super(x, y, width, height, class_2561.method_43473(), defaultValue, onPress);

            if (tooltip != null) method_47400(tooltip);
        }

        @Override
        protected void updateMessage() {
            method_25355(value ? class_5244.field_24332 : class_5244.field_24333);
        }
    }

    public class TitleEntry extends OptionEntry {
        public TitleEntry(class_2561 label) {
            super(class_2561.method_43473().method_10852(label).method_27695(class_124.field_1067, class_124.field_1054));
        }

        @Override
        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int itemY = Math.round(y + entryHeight / 3.0f);
            int titleX = x + (method_25322() / 2 - field_22740.field_1772.method_27525(label) / 2);
            context.method_51439(field_22740.field_1772, label, titleX, itemY, 0xFFFFFFFF, false);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of();
        }
    }

    public class ToggleEntry extends LabeledButtonEntry<ToggleWidget> {
        public ToggleEntry(class_2561 label, boolean defaultValue, boolean active, Consumer<Boolean> onPress) {
            this(label, defaultValue, active, null, onPress);
        }

        public ToggleEntry(
                class_2561 label,
                boolean defaultValue,
                boolean active,
                @Nullable class_7919 tooltip,
                Consumer<Boolean> onPress
        ) {
            super(label, () -> createToggleWidget(defaultValue, tooltip, onPress));
            button.field_22763 = active;
        }
    }

    public class FullButtonEntry extends OptionEntry {
        private final SelectedCursorButtonWidget button;

        protected FullButtonEntry(class_2561 label, class_2561 tooltipText, Runnable onPress) {
            super(label);

            this.button = new SelectedCursorButtonWidget(label, onPress);
            this.button.method_25358(method_25322());
            this.button.field_22759 = 20;
            this.button.method_47400(class_7919.method_47407(tooltipText));
        }

        @Override
        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            button.method_48229(method_25342(), getYEntry(index));
            button.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(button);
        }
    }

    public class SliderEntry extends ToggleEntry {
        private final SelectedCursorSliderWidget sliderWidget;

        public SliderEntry(Slider slider, Toggle toggle, Runnable onRelease) {
            super(class_2561.method_43473(), toggle.value, true, toggle.tooltip, toggle.toggleFunction);

            sliderWidget = new SelectedCursorSliderWidget(
                    slider.label,
                    slider.value,
                    slider.min,
                    slider.max,
                    slider.step,
                    slider.suffix,
                    slider.applyFunction,
                    onRelease
            );
        }

        @Override
        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);

            sliderWidget.field_22763 = this.button.value;
            sliderWidget.method_48229(x - ROW_GAP / 2, getYEntry(index));
            sliderWidget.method_25358(this.button.method_46426() - x - ROW_GAP);
            sliderWidget.field_22759 = 20;
            sliderWidget.method_48579(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(sliderWidget, this.button);
        }

        public record Slider(class_2561 label, String suffix, double value, double min, double max, double step,
                             Consumer<Double> applyFunction) {
        }

        public record Toggle(class_2561 label, boolean value, class_7919 tooltip, Consumer<Boolean> toggleFunction) {
        }
    }
}
