package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_6382;

public class SelectedCursorTestWidget extends SelectedCursorClickableWidget implements CursorProvider {
    private static final class_2960 BACKGROUND = class_2960.method_43902(MinecraftCursor.MOD_ID, "textures/gui/test_background.png");
    private static final int HOTSPOT_RULER_COLOR = 0xFF00FF00; // green
    private static final class_4185 BUTTON = class_4185.method_46430(class_2561.method_43473(),
            b -> b.method_25365(false)).method_46437(20, 20).method_46431();
    private final CursorOptionsWidget options;

    public SelectedCursorTestWidget(int size, CursorOptionsWidget optionsWidget) {
        super(optionsWidget.method_46426(), optionsWidget.method_46427(), size, size, class_2561.method_43473());
        this.options = optionsWidget;

        this.field_22763 = false;
    }

    private void placeButton() {
        int x = method_46426() + (method_25368() / 2 - BUTTON.method_25368() / 2);
        int y = method_46427() + (method_25364() / 2 - BUTTON.method_25364() / 2);
        BUTTON.method_48229(x, y);
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25290(BACKGROUND, method_46426(), method_46427(), 0, 0, field_22758, field_22759, field_22758, field_22759);

        if (options.parent().getSelectedCursor().isEnabled()) {
            BUTTON.method_25394(context, mouseX, mouseY, delta);
            renderRuler(context, mouseX, mouseY);
        } else {
            context.method_25294(method_46426(), method_46427(), getRight(), getBottom(), 0x7F000000); // 50% black overlay
        }

        context.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), 0xFF000000);
        placeButton();
    }

    private void renderRuler(class_332 context, int mouseX, int mouseY) {
        if (method_25405(mouseX, mouseY)) {
            context.method_25292(method_46426(), getRight() - 1, mouseY, HOTSPOT_RULER_COLOR);
            context.method_25301(mouseX, method_46427(), getBottom(), HOTSPOT_RULER_COLOR);
        }
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        return options.parent().getSelectedCursor().getType();
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= this.method_46426()
                && mouseY >= this.method_46427()
                && mouseX < this.getRight()
                && mouseY < this.getBottom();
    }

    @Override
    protected void method_47399(class_6382 builder) {
        // not supported
    }
}
