package io.github.fishstiz.minecraftcursor.impl;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.api.MinecraftCursorInitializer;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.*;
import io.github.fishstiz.minecraftcursor.cursorhandler.multiplayer.MultiplayerServerListWidgetCursorHandler;
import io.github.fishstiz.minecraftcursor.cursorhandler.world.WorldListWidgetCursorHandler;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3928;
import net.minecraft.class_424;
import net.minecraft.class_4264;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_8209;
import net.minecraft.client.gui.components.*;

public class MinecraftCursorInitializerImpl implements MinecraftCursorInitializer {
    @Override
    public void init(CursorTypeRegistrar cursorRegistrar, ElementRegistrar elementRegistrar) {
        cursorRegistrar.register(
                CursorType.DEFAULT,
                CursorType.POINTER,
                CursorType.GRABBING,
                CursorType.TEXT,
                CursorType.SHIFT,
                CursorType.BUSY,
                CursorType.CROSSHAIR,
                CursorType.RESIZE_EW,
                CursorType.RESIZE_NS,
                CursorType.RESIZE_NWSE,
                CursorType.RESIZE_NESW,
                CursorType.NOT_ALLOWED
        );

        elementRegistrar.register(class_424.class, MinecraftCursorInitializerImpl::elementToBusy);
        elementRegistrar.register(class_434.class, MinecraftCursorInitializerImpl::elementToBusy);
        elementRegistrar.register(class_435.class, MinecraftCursorInitializerImpl::elementToBusy);
        elementRegistrar.register(class_3928.class, MinecraftCursorInitializerImpl::elementToBusy);
        elementRegistrar.register(class_4264.class, MinecraftCursorInitializerImpl::clickableWidgetCursor);
        elementRegistrar.register(class_8209.class, MinecraftCursorInitializerImpl::tabButtonWidgetCursor);
        elementRegistrar.register(class_357.class, MinecraftCursorInitializerImpl::sliderWidgetCursor);
        elementRegistrar.register(class_342.class, MinecraftCursorInitializerImpl::textFieldWidgetCursor);
        elementRegistrar.register(new WorldListWidgetCursorHandler());
        elementRegistrar.register(new HandledScreenCursorHandler<>());
        elementRegistrar.register(new MultiplayerServerListWidgetCursorHandler());
        elementRegistrar.register(RecipeBookScreenCursorHandler.INVENTORY);
        elementRegistrar.register(RecipeBookScreenCursorHandler.CRAFTING);
        elementRegistrar.register(RecipeBookScreenCursorHandler.FURNACE);
        elementRegistrar.register(new CreativeInventoryScreenCursorHandler());
        elementRegistrar.register(new BookEditScreenCursorHandler());
        elementRegistrar.register(new EnchantmentScreenCursorHandler());
        elementRegistrar.register(new StonecutterScreenCursorHandler());
        elementRegistrar.register(new LoomScreenCursorHandler());
        elementRegistrar.register(new AdvancementsScreenCursorHandler());
    }

    private static <T extends class_364> CursorType elementToBusy(T ignoreElement, double ignoreMouseX, double ignoreMouseY) {
        return CursorType.BUSY;
    }

    private static <T extends class_339> CursorType clickableWidgetCursor(T clickable, double mouseX, double mouseY) {
        return clickable.field_22763 && clickable.field_22764 && clickable.method_49606() ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private static <T extends class_8209> CursorType tabButtonWidgetCursor(T tabButton, double mouseX, double mouseY) {
        return tabButton.field_22763 && tabButton.field_22764 && tabButton.method_49606() && !tabButton.method_49611() ?
                CursorType.POINTER : CursorType.DEFAULT;
    }

    private static <T extends class_357> CursorType sliderWidgetCursor(T slider, double mouseX, double mouseY) {
        if (slider.method_25370() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return slider.field_22763 && slider.field_22764 ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private static <T extends class_342> CursorType textFieldWidgetCursor(T textField, double mouseX, double mouseY) {
        return textField.field_22764 && textField.method_49606() ? CursorType.TEXT : CursorType.DEFAULT;
    }
}
