package io.github.fishstiz.minecraftcursor;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class MinecraftCursorFabric implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        MinecraftCursor.init();

        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new CursorResourceReloadListener());
        ScreenEvents.BEFORE_INIT.register(this::onScreenInit);
        ClientTickEvents.START_CLIENT_TICK.register(MinecraftCursor::onClientTick);
    }

    private void onScreenInit(class_310 minecraft, class_437 screen, int width, int height) {
        MinecraftCursor.onScreenInit(minecraft, screen);
        ScreenEvents.afterRender(screen).register(this::onScreenRender);
    }

    private void onScreenRender(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        MinecraftCursor.onScreenRender(MinecraftHolder.INSTANCE, screen, guiGraphics, mouseX, mouseY);
    }

    private static class MinecraftHolder {
        private static final class_310 INSTANCE = class_310.method_1551();
    }
}
