package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

public class CursorOptionsScreen extends class_437 {
    private static final class_2561 TITLE_TEXT = class_2561.method_43471("minecraft-cursor.options");
    private static final int CURSORS_COLUMN_WIDTH = 96;
    private static final int SELECTED_CURSOR_COLUMN_WIDTH = 200;
    private static final int COLUMN_GAP = 8;

    public final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private final class_437 previousScreen;
    private final class_8132 layout = new class_8132(this);
    private @NotNull Collection<Cursor> cursors;
    private Cursor selectedCursor;
    private CursorListWidget list;
    @Nullable CursorOptionsWidget options;
    private boolean initialized;

    public CursorOptionsScreen(class_437 previousScreen) {
        super(TITLE_TEXT);

        this.previousScreen = previousScreen;

        cursors = CursorManager.INSTANCE.getCursors();
    }

    @Override
    public void method_49589() {
        if (this.initialized) {
            this.refresh();
        }
    }

    @Override
    protected void method_25426() {
        selectedCursor = this.cursors.iterator().next();

        this.layout.method_57726(this.field_22785, this.field_22793);
        this.layout.method_48999(initContents(class_8667.method_52742().method_52735(COLUMN_GAP)));
        this.layout.method_48996(initFooter(class_8667.method_52742().method_52735(COLUMN_GAP)));
        this.layout.method_48206(this::method_37063);
        this.method_48640();

        this.initialized = true;
    }

    protected class_8667 initContents(class_8667 contents) {
        this.list = contents.method_52736(new CursorListWidget(
                field_22787,
                CURSORS_COLUMN_WIDTH,
                layout.method_57727(),
                layout.method_48998(),
                this
        ));
        this.options = contents.method_52736(new CursorOptionsWidget(0, SELECTED_CURSOR_COLUMN_WIDTH,
                layout.method_57727(),
                layout.method_48998(),
                this
        ));
        return contents;
    }

    protected class_8667 initFooter(class_8667 footer) {
        footer.method_52736(class_4185.method_46430(class_2561.method_43471("minecraft-cursor.options.more").method_27693("..."),
                btn -> toMoreOptions()).method_46431());
        footer.method_52736(class_4185.method_46430(class_5244.field_24334, btn -> this.method_25419()).method_46431());
        return footer;
    }

    @Override
    protected void method_48640() {
        this.layout.method_48222();
        this.list.method_53533(layout.method_57727());
        this.list.method_46419(layout.method_48998());
        this.list.method_60322();

        if (this.options != null) {
            this.options.method_53533(layout.method_57727());
            this.options.method_46419(layout.method_48998());
        }
    }

    public void selectCursor(Cursor cursor) {
        updateSelectedCursorConfig();
        selectedCursor = cursor;

        if (this.options != null) {
            this.options.refresh();
        }
    }

    private void updateSelectedCursorConfig() {
        if (this.options != null) {
            this.options.save();
        }
    }

    public Cursor getSelectedCursor() {
        return selectedCursor;
    }

    public @NotNull Collection<Cursor> getCursors() {
        return cursors;
    }

    public void toMoreOptions() {
        if (field_22787 != null) {
            field_22787.method_1507(new MoreOptionsScreen(this));
        }
    }

    public void refresh() {
        CursorType previous = this.getSelectedCursor().getType();
        cursors = CursorManager.INSTANCE.getCursors();
        this.selectCursor(CursorManager.INSTANCE.getCursor(previous));
        this.list.refreshEntries();
        if (this.options != null) {
            options.refresh();
        }
    }

    @Override
    public void method_25419() {
        CursorOptionsHandler.removeScaleOverride();
        CONFIG.save();

        if (this.field_22787 != null) {
            this.field_22787.method_1507(previousScreen);
        }
    }
}
