package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen extends class_437 {
    private static final int FOOTER_SPACING = 8;
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final class_8132 layout = new class_8132(this);
    private final class_437 previousScreen;
    private @Nullable SelectedCursorHotspotWidget hotspotWidget;
    private MoreOptionsListWidget list;

    protected MoreOptionsScreen(class_437 previousScreen) {
        super(class_2561.method_43471("minecraft-cursor.options.more"));

        this.previousScreen = previousScreen;
    }

    @Override
    protected void method_25426() {
        this.list = new MoreOptionsListWidget(this.field_22787, field_22789, layout.method_57727(), layout.method_48998());

        if (previousScreen instanceof CursorOptionsScreen previous
            && previous.options != null
            && previous.getSelectedCursor().isLoaded()) {
            this.hotspotWidget = new SelectedCursorHotspotWidget(
                    HOTSPOT_WIDGET_SIZE,
                    previous.options
            );

            this.hotspotWidget.field_22764 = false;
            this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
            this.method_25429(this.hotspotWidget);
        }

        this.layout.method_57726(this.field_22785, this.field_22793);
        this.layout.method_48999(this.list);
        this.layout.method_48996(this.createFooter());
        this.layout.method_48206(this::method_37063);

        this.method_48640();
    }

    private class_8667 createFooter() {
        class_8667 footer = class_8667.method_52742().method_52735(FOOTER_SPACING);

        class_2960 inspectIcon = class_2960.method_60656("textures/gui/sprites/icon/search.png");
        int iconSize = 12;
        int inspectSize = 20;

        class_4185 inspect = new SelectedCursorButtonWidget(inspectIcon, iconSize, iconSize, MinecraftCursor::toggleInspect);
        inspect.method_55445(inspectSize, inspectSize);

        footer.method_52736(inspect);
        footer.method_52736(class_4185.method_46430(class_5244.field_24334, btn -> this.method_25419()).method_46431());

        return footer;
    }

    @Override
    protected void method_48640() {
        if (this.list != null) {
            this.layout.method_48222();
            this.list.method_57712(field_22789, layout);
        }
    }

    @Override
    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        if (list == null || hotspotWidget == null) return;

        if (list.isEditingHotspot()) {
            int rowGap = list.getRowGap();
            int x = list.method_25342() - hotspotWidget.method_25368() - rowGap;
            int y = list.getYEntry(1) + rowGap / 2;

            hotspotWidget.method_48229(x, y);
            hotspotWidget.field_22764 = true;
            hotspotWidget.field_22763 = true;

            context.method_44379(x, layout.method_48998(), list.method_25342(), layout.method_48998() + layout.method_57727());
            hotspotWidget.method_25394(context, mouseX, mouseY, delta);
            context.method_44380();
        } else {
            hotspotWidget.field_22764 = false;
            hotspotWidget.field_22763 = false;
        }
    }

    @Override
    public void method_25419() {
        list.applyConfig();

        if (this.field_22787 != null) {
            this.field_22787.method_1507(previousScreen);
        }
    }
}
