package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import org.jetbrains.annotations.NotNull;

import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;
import static io.github.fishstiz.minecraftcursor.MinecraftCursor.MOD_ID;

public class SelectedCursorHotspotWidget extends class_339 implements CursorProvider {
    private static final class_2960 BACKGROUND_64 = class_2960.method_60655(MOD_ID, "textures/gui/background_64.png");
    private static final int BACKGROUND_DISABLED = 0xAF000000; // 70% black
    private static final int BORDER_COLOR = 0xFF000000; // black
    private static final int RULER_COLOR = 0xFFFF0000; // red
    private static final int OVERRIDE_RULER_COLOR = 0xFF00FF00; // green
    private final Config.GlobalSettings global = CONFIG.getGlobal();
    private final CursorOptionsWidget options;
    private boolean rulerRendered = true;
    private float rulerAlpha = 1f;
    private boolean dragging = false;
    private MouseEventListener changeEventListener;

    public SelectedCursorHotspotWidget(int size, CursorOptionsWidget options) {
        super(options.method_46426(), options.method_46427(), size, size, class_2561.method_43473());
        this.options = options;
    }

    @Override
    protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        DrawUtil.drawCheckerboard(context, method_46426(), method_46427(), method_25368(), method_25364(), getCellSize(), BACKGROUND_64, 64);
        if (!field_22763) context.method_25294(method_46426(), method_46427(), method_55442(), method_55443(), BACKGROUND_DISABLED);

        renderCursor(context);
        renderRuler(context, mouseX, mouseY);
        context.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), BORDER_COLOR);
    }

    private void renderCursor(class_332 context) {
        options.parent().animationHelper.drawSprite(context, options.parent().getSelectedCursor(), method_46426(), method_46427(), field_22758);
    }

    private void renderRuler(class_332 context, int mouseX, int mouseY) {
        if (method_25405(mouseX, mouseY)) setRulerRendered(true, false);

        rulerAlpha = class_3532.method_16439(0.3f, rulerAlpha, rulerRendered ? 1f : 0f);

        if (rulerAlpha <= 0.01f) return;

        boolean isGlobalX = global.isXHotActive();
        boolean isGlobalY = global.isYHotActive();

        int alpha = (int) (rulerAlpha * 255);
        int blendedColorX = getBlendedColor(isGlobalX ? OVERRIDE_RULER_COLOR : RULER_COLOR, alpha);
        int blendedColorY = getBlendedColor(isGlobalY ? OVERRIDE_RULER_COLOR : RULER_COLOR, alpha);

        int xhot = clampHotspot(isGlobalX ? global.getXHot() : (int) options.xhotSlider.getTranslatedValue());
        int yhot = clampHotspot(isGlobalY ? global.getYHot() : (int) options.yhotSlider.getTranslatedValue());

        float rulerSize = this.getCellSize();
        int xhotX1 = (int) (method_46426() + xhot * rulerSize);
        int xhotX2 = (int) ((method_46426() + xhot * rulerSize) + (xhot > 0 ? rulerSize : Math.max(rulerSize, 2)));
        int yhotY1 = (int) (method_46427() + yhot * rulerSize);
        int yhotY2 = (int) ((method_46427() + yhot * rulerSize) + (yhot > 0 ? rulerSize : Math.max(rulerSize, 2)));

        if ((isGlobalX && !isGlobalY) || (isGlobalX == isGlobalY)) {
            context.method_25294(method_46426(), yhotY1, method_55442(), yhotY2, blendedColorY);
            context.method_25294(xhotX1, method_46427(), xhotX2, method_55443(), blendedColorX);
        } else {
            context.method_25294(xhotX1, method_46427(), xhotX2, method_55443(), blendedColorX);
            context.method_25294(method_46426(), yhotY1, method_55442(), yhotY2, blendedColorY);
        }
    }

    public int getBlendedColor(int color, int alpha) {
        return (alpha << 24) | (color & 0x00FFFFFF);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.dragging = true;
        setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    @Override
    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        setHotspots(MouseEvent.DRAG, mouseX, mouseY);
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        if (changeEventListener != null) {
            float cellSize = getCellSize();
            int x = clampHotspot((int) ((mouseX - method_46426()) / cellSize));
            int y = clampHotspot((int) ((mouseY - method_46427()) / cellSize));

            changeEventListener.onChange(mouseEvent, x, y);
        }

        setRulerRendered(true, true);
    }

    private float getCellSize() {
        return (float) method_25368() / this.options.parent().getSelectedCursor().getTextureWidth();
    }

    private int clampHotspot(int hotspot) {
        return SettingsUtil.sanitizeHotspot(hotspot, options.parent().getSelectedCursor());
    }

    public void setRulerRendered(boolean rulerRendered, boolean immediate) {
        if (immediate) rulerAlpha = rulerRendered ? 1f : 0f;
        this.rulerRendered = rulerRendered;
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!field_22763) {
            return CursorType.DEFAULT;
        }
        if (this.dragging) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public void setChangeEventListener(BiConsumer<Integer, Integer> changeEventListener) {
        setChangeEventListener((mouseEvent, x, y) -> changeEventListener.accept(x, y));
    }

    public void setChangeEventListener(MouseEventListener changeEventListener) {
        this.changeEventListener = changeEventListener;
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        if (this.dragging) {
            setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
            this.dragging = false;
        }
    }

    @Override
    protected void method_47399(@NotNull class_6382 builder) {
        this.method_37021(builder);
    }

    @FunctionalInterface
    public interface MouseEventListener {
        void onChange(MouseEvent mouseEvent, int xhot, int yhot);
    }
}
