package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class SelectedCursorSliderWidget extends class_357 {
    private final class_2561 prefix;
    private final double step;
    private final String suffix;
    private final Consumer<Double> onApply;
    private final @Nullable Runnable onRelease;
    private double min;
    private double max;
    private double translatedValue;
    private SelectedCursorButtonWidget inactiveHelperButton;
    private TextMapper textMapper;

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            Consumer<Double> onApply,
            Runnable onRelease
    ) {
        this(text, defaultValue, min, max, step, "", onApply, onRelease);
    }

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            String suffix,
            Consumer<Double> onApply
    ) {
        this(text, defaultValue, min, max, step, suffix, onApply, null);
    }

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            String suffix,
            Consumer<Double> onApply,
            @Nullable Runnable onRelease
    ) {
        super(0, 0, 0, 0, text, defaultValue);

        this.prefix = text;
        this.min = min;
        this.max = max;
        this.step = step;
        this.suffix = suffix;
        this.onApply = onApply;
        this.onRelease = onRelease;

        this.field_22753 = translatedValueToValue(defaultValue);

        translateValue();
        method_25346();
    }

    private double translatedValueToValue(double translatedValue) {
        double clampedValue = Math.max(min, Math.min(translatedValue, max));
        return (clampedValue - min) / (max - min);
    }

    public void setTextMapper(TextMapper mapper) {
        this.textMapper = mapper;
        this.method_25346();
    }

    public void update(double min, double max, double translatedValue, boolean active) {
        this.min = min;
        this.max = max;
        setTranslatedValue(SettingsUtil.clamp(translatedValue, this.min, this.max));
        this.field_22763 = active;
    }

    public void setTranslatedValue(double translatedValue) {
        this.field_22753 = translatedValueToValue(translatedValue);

        method_25344();
        method_25346();
    }

    private void translateValue() {
        double scaledValue = min + (field_22753 * (max - min));
        this.translatedValue = Math.round(scaledValue / step) * step;
    }

    @Override
    public void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);

        SelectedCursorButtonWidget helperButton = getInactiveHelperButton();
        boolean isHelperButtonPresent = helperButton != null;

        if (isHelperButtonPresent) {
            helperButton.field_22763 = !field_22763;

            if (isMouseOverInactive(mouseX, mouseY)) {
                class_4587 poseStack = context.method_51448();
                poseStack.method_22903();
                poseStack.method_46416(0, 0, 1f);
                helperButton.method_25394(context, mouseX, mouseY, delta);
                poseStack.method_22909();
            }
        }

        field_22762 = method_25405(mouseX, mouseY);
    }

    @Override
    protected void method_25344() {
        double previousTranslatedValue = translatedValue;

        translateValue();

        if (method_25370() && previousTranslatedValue != translatedValue) {
            onApply.accept(translatedValue);
        }
    }

    @Override
    protected void method_25346() {
        class_5250 label = prefix.method_27661().method_27693(": ");
        class_2561 message = null;

        if (textMapper != null) {
            class_2561 mappedText = textMapper.getText(translatedValue);
            if (mappedText != null) {
                message = label.method_10852(mappedText);
            }
        }

        if (message == null) {
            String formattedValue = String.format(step % 1 == 0 ? "%.0f" : "%.2f", translatedValue);
            message = label.method_27693(formattedValue + suffix);
        }

        method_25355(message);
    }

    public double getTranslatedValue() {
        return translatedValue;
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        method_25365(false);

        if (this.onRelease != null) {
            this.onRelease.run();
        }
    }

    public @Nullable SelectedCursorButtonWidget getInactiveHelperButton() {
        if (inactiveHelperButton == null) return null;

        int marginRight = 2;
        int x = (method_46426() + method_25368()) - inactiveHelperButton.method_25368() - marginRight;
        int y = method_46427() + (method_25364() - inactiveHelperButton.method_25364()) / 2;

        inactiveHelperButton.method_48229(x, y);
        return inactiveHelperButton;
    }

    public void setInactiveHelperButton(SelectedCursorButtonWidget helperButton, int width, int height) {
        this.inactiveHelperButton = helperButton;
        this.inactiveHelperButton.method_55445(width, height);
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    public boolean isMouseOverInactive(int mouseX, int mouseY) {
        return !field_22763
               && mouseX >= method_46426()
               && mouseY >= method_46427()
               && mouseX < method_55442()
               && mouseY < method_55443();
    }

    @FunctionalInterface
    public interface TextMapper {
        @Nullable class_2561 getText(double translatedValue);
    }
}