package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.MOD_ID;

public class SelectedCursorTestWidget extends class_339 implements CursorProvider {
    private static final class_2960 BACKGROUND_64 = class_2960.method_60655(MOD_ID, "textures/gui/background_dark_64.png");
    private static final int BACKGROUND_DISABLED = 0x7F000000; // 50% black
    private static final int BORDER_COLOR = 0xFF000000; // black
    private static final int HOTSPOT_RULER_COLOR = 0xFF00FF00; // green
    private final class_4185 testButton = class_4185.method_46430(class_2561.method_43473(), b -> b.method_25365(false)).method_46437(20, 20).method_46431();
    private final CursorOptionsWidget options;

    public SelectedCursorTestWidget(int size, CursorOptionsWidget optionsWidget) {
        super(optionsWidget.method_46426(), optionsWidget.method_46427(), size, size, class_2561.method_43473());
        this.options = optionsWidget;

        this.field_22763 = false;
    }

    @Override
    protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        float cellSize = (float) method_25368() / this.options.parent().getSelectedCursor().getTextureWidth();
        DrawUtil.drawCheckerboard(context, method_46426(), method_46427(), method_25368(), method_25364(), cellSize, BACKGROUND_64, 64);

        if (this.isEnabled()) {
            int x = method_46426() + (method_25368() / 2 - testButton.method_25368() / 2);
            int y = method_46427() + (method_25364() / 2 - testButton.method_25364() / 2);
            testButton.method_48229(x, y);
            testButton.method_25394(context, mouseX, mouseY, delta);
            renderRuler(context, mouseX, mouseY);
        } else {
            context.method_25294(method_46426(), method_46427(), method_55442(), method_55443(), BACKGROUND_DISABLED);
        }

        context.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), BORDER_COLOR);
    }

    private void renderRuler(class_332 context, int mouseX, int mouseY) {
        if (method_25405(mouseX, mouseY)) {
            context.method_25292(method_46426(), method_55442() - 1, mouseY, HOTSPOT_RULER_COLOR);
            context.method_25301(mouseX, method_46427(), method_55443(), HOTSPOT_RULER_COLOR);
        }
    }

    public boolean isEnabled() {
        return options.parent().getSelectedCursor().isEnabled();
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        return options.parent().getSelectedCursor().getType();
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= this.method_46426()
                && mouseY >= this.method_46427()
                && mouseX < this.method_55442()
                && mouseY < this.method_55443();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.method_25351(button)) {
            testButton.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    protected void method_47399(@NotNull class_6382 builder) {
        this.method_37021(builder);
    }
}
