package io.github.fishstiz.minecraftcursor.inspect;

import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public interface ElementInspector {
    ElementInspector NO_OP = new ElementInspector() {
    };

    default void destroy() {
        // no-op
    }

    default boolean setFocused(class_364 hovered, boolean cached) {
        return false;
    }

    default void render(class_310 minecraft, @NotNull class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        // no-op
    }

    static ElementInspector toggle(ElementInspector elementInspector) {
        elementInspector.destroy();
        return elementInspector instanceof ElementInspectorImpl ? NO_OP : new ElementInspectorImpl();
    }
}
