package io.github.fishstiz.minecraftcursor.inspect;

import io.github.fishstiz.minecraftcursor.platform.Services;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

public final class ElementInspectorImpl implements ElementInspector {
    private static final class_2561 SCREEN_LABEL = class_2561.method_43470("S: ").method_54663(0xFF339BFF); // blue
    private static final class_2561 CACHE_LABEL = class_2561.method_43470("Cache: ").method_54663(0xFFFFFFFF); // white
    private static final class_2561 DEEPEST_LABEL = class_2561.method_43470("D: ").method_54663(0xFF00FF00); // green
    private static final class_2561 FOCUSED_LABEL = class_2561.method_43470("F: ").method_54663(0xFFFF0000); // red
    private static final float Z = 2000f;
    private static final float TEXT_SCALE = 0.75f;
    private HashSet<String> cache = new HashSet<>();
    private class_364 focused;
    private String focusedName;
    private boolean enabled = true;

    @Override
    public void destroy() {
        this.enabled = false;
        this.cache.clear();
        this.cache = null;
        this.focused = null;
        this.focusedName = null;
    }

    @Override
    public boolean setFocused(class_364 focused, boolean cached) {
        this.focused = focused;
        this.focusedName = getClassName(focused);
        if (cached) {
            this.cache.add(focusedName);
        }
        return true;
    }

    @Override
    public void render(class_310 minecraft, @NotNull class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        if (this.enabled) {
            class_8030 screenRectangle = getBounds(screen);
            renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            renderCacheSize(minecraft, screenRectangle, guiGraphics);
            renderFocused(minecraft, renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
        }
    }

    private class_8030 renderDeepest(class_310 minecraft, class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_364 child = findDeepestChild(screen, mouseX, mouseY);
        class_364 inspect = child != null ? child : screen;
        class_8030 bounds = getBounds(inspect);
        class_2561 label = DEEPEST_LABEL.method_27661().method_27693(getClassName(inspect));
        renderInfo(minecraft, guiGraphics, bounds, label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderFocused(class_310 minecraft, class_8030 container, class_332 guiGraphics) {
        if (focused != null) {
            class_2561 label = FOCUSED_LABEL.method_27661().method_27693(focusedName);
            class_8030 bounds = getBounds(focused);
            int offsetY = bounds.method_49618() != container.method_49618() ? 0 : minecraft.field_1772.field_2000;

            renderInfo(minecraft, guiGraphics, bounds, label, Position.TOP_LEFT, offsetY, true);
        }
    }

    private void renderScreenName(class_310 minecraft, class_437 screen, class_8030 bounds, class_332 guiGraphics) {
        class_2561 label = SCREEN_LABEL.method_27661().method_27693(getClassName(screen));
        this.renderInfo(minecraft, guiGraphics, bounds, label, Position.BOTTOM_RIGHT, false);
    }

    private void renderCacheSize(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        if (cache != null) {
            class_2561 label = CACHE_LABEL.method_27661().method_27693(String.valueOf(cache.size()));
            int offsetY = -minecraft.field_1772.field_2000;
            renderInfo(minecraft, guiGraphics, screenBounds, label, Position.BOTTOM_RIGHT, offsetY, false);
        }
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, int offsetY, boolean outline) {
        class_5251 textColor = label.method_10866().method_10973();
        int color = textColor != null ? textColor.method_27716() : 0xFFFFFFFF;

        int textWidth = minecraft.field_1772.method_27525(label);
        int textHeight = minecraft.field_1772.field_2000;
        int textX = pos.getX(bounds, textWidth, TEXT_SCALE, minecraft.method_22683().method_4486());
        int textY = pos.getY(bounds, offsetY, textHeight, TEXT_SCALE, minecraft.method_22683().method_4502());

        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0, 0, Z);

        if (outline) {
            guiGraphics.method_49601(bounds.method_49620(), bounds.method_49618(), bounds.comp_1196(), bounds.comp_1197(), 0xFF000000 | color);
        }

        poseStack.method_22905(TEXT_SCALE, TEXT_SCALE, 0);
        guiGraphics.method_27535(minecraft.field_1772, label, (int) (textX / TEXT_SCALE), (int) (textY / TEXT_SCALE), color);

        poseStack.method_22909();
    }

    private class_8030 getBounds(@Nullable class_364 element) {
        if (element instanceof class_8021 layoutElement) {
            return layoutElement.method_48202();
        }
        return element != null ? element.method_48202() : class_8030.method_48248();
    }

    private String getClassName(class_364 element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    private @Nullable class_364 findDeepestChild(class_4069 parent, double mouseX, double mouseY) {
        Optional<class_364> child = parent.method_19355(mouseX, mouseY);
        if (child.isPresent()) {
            class_364 hoveredElement = child.get();
            if (hoveredElement instanceof class_4069 nestedParent) {
                class_364 deepChild = findDeepestChild(nestedParent, mouseX, mouseY);
                return (deepChild != null) ? deepChild : hoveredElement;
            }
            return hoveredElement;
        }
        return null;
    }

    public enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int OFFSET = 2;

        public int getX(class_8030 rect, int textWidth, float scale, int screenWidth) {
            int x = switch (this) {
                case TOP_LEFT, BOTTOM_LEFT -> rect.method_49620() + OFFSET;
                case TOP_RIGHT, BOTTOM_RIGHT -> rect.method_49620() + rect.comp_1196() - (int) (textWidth * scale);
            };

            if ((x + textWidth * scale) > screenWidth) {
                x = (int) (screenWidth - textWidth * scale);
                if (x < 0) x = 0;
            }

            return x;
        }

        public int getY(class_8030 rect, int offsetY, int textHeight, float scale, int screenHeight) {
            return switch (this) {
                case TOP_LEFT, TOP_RIGHT -> rect.method_49618() + OFFSET + offsetY;
                case BOTTOM_LEFT, BOTTOM_RIGHT -> {
                    if (rect.comp_1197() == 0 && rect.comp_1196() == 0) {
                        yield screenHeight - (int) (textHeight * scale) - OFFSET - offsetY;
                    }
                    yield rect.method_49618() - OFFSET + Math.max(0, rect.comp_1197() - (int) (textHeight * scale)) + offsetY;
                }
            };
        }
    }
}
