package io.github.fishstiz.minecraftcursor.mixin.cursorprovider;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

@Mixin(class_465.class)
public abstract class AbstractContainerScreenMixin implements InternalCursorProvider {
    @Shadow @Final protected class_1703 menu;

    @Shadow @Nullable protected class_1735 hoveredSlot;

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        boolean canClickFocusedSlot = menu.method_34255().method_7960()
                                      && hoveredSlot != null
                                      && hoveredSlot.method_7681()
                                      && hoveredSlot.method_51306();

        if (canClickFocusedSlot && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (CONFIG.isItemSlotEnabled() && canClickFocusedSlot) {
            return CursorType.POINTER;
        }
        if (CONFIG.isItemGrabbingEnabled() && !menu.method_34255().method_7960()) {
            return CursorType.GRABBING;
        }
        return CursorType.DEFAULT;
    }
}
