package io.github.fishstiz.minecraftcursor.mixin.cursorprovider;

import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_350.class)
public abstract class AbstractSelectionListMixin {
    @Shadow
    private boolean scrolling;

    @Shadow protected abstract boolean scrollbarVisible();

    @Inject(method = "renderWidget", at = @At(value = "TAIL"))
    public void forceDefaultCursor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.scrolling && this.scrollbarVisible() && CursorTypeUtil.isLeftClickHeld()) {
            CursorController.getInstance().setSingleCycleCursor(CursorType.DEFAULT_FORCE);
        }
    }
}
