package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class CursorTypeUtil {
    private CursorTypeUtil() {
    }

    public static final long WINDOW = class_310.method_1551().method_22683().method_4490();

    public static boolean canShift() {
        return CursorManager.INSTANCE.getId(CursorType.SHIFT) != 0 &&
               class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_LEFT_SHIFT) ||
               class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_RIGHT_SHIFT);
    }

    public static boolean isGrabbing() {
        return CursorManager.INSTANCE.getId(CursorType.GRABBING) != 0 &&
               CursorManager.INSTANCE.getAppliedCursor().getType().isKey(CursorType.GRABBING) &&
               isLeftClickHeld();
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton(WINDOW, GLFW.GLFW_MOUSE_BUTTON_1) == GLFW.GLFW_PRESS;
    }
}
