package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class SettingsUtil {
    public static final Set<Integer> SUPPORTED_SIZES = Set.of(8, 16, 32, 48, 64);
    public static final double SCALE_AUTO_THRESHOLD_MAX = 0.49;
    public static final double SCALE = 1.0;
    public static final double SCALE_MIN = 0;
    public static final double SCALE_MAX = 8.0;
    public static final double SCALE_STEP = 0.05;
    public static final int X_HOT = 0;
    public static final int Y_HOT = 0;
    public static final int HOT_MIN = 0;
    public static final int GLOBAL_HOT_MAX = Collections.max(SUPPORTED_SIZES) - 1;
    public static final boolean ENABLED = true;

    private SettingsUtil() {
    }

    public static boolean isAutoScale(double scale) {
        return scale <= SCALE_AUTO_THRESHOLD_MAX;
    }

    public static class_2561 getAutoText(double scale) {
        return isAutoScale(scale) ? class_2561.method_43471("options.guiScale.auto") : null;
    }

    public static double getAutoScale(double scale) {
        return isAutoScale(scale) ? class_310.method_1551().method_22683().method_4495() : scale;
    }

    public static double sanitizeScale(double scale) {
        double clampedScale = clamp(scale, SCALE_MIN, SCALE_MAX);
        double mappedScale = Math.round(clampedScale / SCALE_STEP) * SCALE_STEP;

        if (isAutoScale(mappedScale)) {
            return 0;
        }

        return (double) Math.round(mappedScale * 100) / 100;
    }

    public static int sanitizeHotspot(int hotspot, Cursor cursor) {
        return clamp(hotspot, HOT_MIN, cursor.isLoaded() ? Objects.requireNonNull(cursor).getTextureWidth() - 1 : GLOBAL_HOT_MAX);
    }

    public static int sanitizeGlobalHotspot(int hotspot) {
        return clamp(hotspot, HOT_MIN, GLOBAL_HOT_MAX);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int getMaxHotspot(Collection<Cursor> cursors) {
        int max = SUPPORTED_SIZES.iterator().next();
        for (Cursor cursor : cursors) {
            if (cursor.isLoaded()) {
                int textureWidth = cursor.getTextureWidth();
                if (textureWidth > max) {
                    max = textureWidth;
                }
            }
        }
        return max;
    }
}
