package io.github.fishstiz.cursors_extended;

import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.cursor.CursorDisplay;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.resource.CursorTextureLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CursorsExtended implements ClientStartedListener {
    private static final CursorsExtended INSTANCE = new CursorsExtended();
    public static final String MOD_ID = "cursors_extended";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static final Config CONFIG = Config.load();
    private final CursorRegistry registry = new CursorRegistry();
    private final CursorDisplay display = new CursorDisplay(registry);
    private final CursorTextureLoader textureLoader = new CursorTextureLoader(registry);

    private CursorsExtended() {
    }

    public void onClientStarted(class_310 minecraft) {
        registry.onClientStarted(minecraft);
        textureLoader.onClientStarted(minecraft);
        display.onClientStarted(minecraft);

    }

    public static CursorsExtended getInstance() {
        return INSTANCE;
    }

    public CursorRegistry getRegistry() {
        return registry;
    }

    public CursorTextureLoader getLoader() {
        return textureLoader;
    }

    public CursorDisplay getDisplay() {
        return display;
    }

    public static class_2960 loc(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }
}
