package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.debug.CursorDebugRenderer;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class CursorDisplay implements ClientStartedListener {
    private final CursorRegistry registry;
    private class_310 minecraft;
    private CursorDebugRenderer debugRenderer = CursorDebugRenderer.NOP;
    private CursorRenderer cursorRenderer;
    private @Nullable class_437 visibleScreen;

    public CursorDisplay(CursorRegistry registry) {
        this.registry = registry;
        this.cursorRenderer = new CursorRenderer.Native(registry);
    }

    @Override
    public void onClientStarted(class_310 minecraft) {
        this.minecraft = minecraft;

        if (CursorsExtended.CONFIG.isVirtualMode() != isVirtual()) {
            this.toggleVirtual();
        }
    }

    public class_11875 getCursorAt(class_1041 window) {
        class_437 screen = getVisibleScreen();

        if (screen != null) {
            double mouseX = minecraft.field_1729.method_68879(window);
            double mouseY = minecraft.field_1729.method_68883(window);
            return getCursorAt(screen, mouseX, mouseY);
        }

        return class_11875.field_62449;
    }

    /**
     * Recursively inspects a GUI element (and its children if it’s a container)
     * to determine the appropriate cursor type at the given mouse position.
     * <p>
     * Stops at the first hovered child, matching the default implementation of
     * {@link class_4069#method_25402}.
     */
    public class_11875 getCursorAt(class_364 element, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered(element, mouseX, mouseY)) {
            if (element instanceof class_4069 container) {
                for (class_364 child : container.method_25396()) {
                    class_11875 cursorType = getCursorAt(child, mouseX, mouseY);
                    if (CursorTypeUtil.nonDefault(cursorType)) {
                        return cursorType;
                    }
                }
            }
            if (element instanceof CursorProvider provider) {
                debugRenderer.setLastCursorAt(element, mouseX, mouseY);
                return provider.cursors_extended$cursorType(mouseX, mouseY);
            }
            debugRenderer.setLastCursorAt(element, mouseX, mouseY);
        }
        return class_11875.field_62449;
    }

    public void setVisibleScreen(@Nullable class_437 visibleScreen) {
        this.visibleScreen = visibleScreen;
    }

    public @Nullable class_437 getVisibleScreen() {
        class_437 screen = minecraft.field_1755;
        return screen != null ? screen : visibleScreen;
    }

    public void toggleVirtual() {
        cursorRenderer.resetCursor(minecraft.method_22683());
        cursorRenderer = isVirtual() ? new CursorRenderer.Native(registry) : new CursorRenderer.Virtual(registry);
    }

    public void renderCursor(class_1041 window, class_332 guiGraphics, int mouseX, int mouseY) {
        cursorRenderer.render(window, minecraft, guiGraphics, mouseX, mouseY);
    }

    public boolean isVirtual() {
        return cursorRenderer instanceof CursorRenderer.Virtual;
    }

    public void toggleDebugger() {
        boolean debugging = isDebugging();
        debugRenderer = debugging ? CursorDebugRenderer.NOP : CursorDebugRenderer.create();
    }

    public void renderDebugger(class_332 guiGraphics, int mouseX, int mouseY) {
        debugRenderer.render(minecraft, this::getVisibleScreen, guiGraphics, mouseX, mouseY);
    }

    public boolean isDebugging() {
        return debugRenderer.isActive();
    }

    public void applyCursor(class_1041 window) {
        cursorRenderer.applyCursor(window);
    }

    public Cursor getDisplayedCursor(class_1041 window) {
        return cursorRenderer.getCurrentCursor(window);
    }

    public Cursor getDisplayedCursor() {
        return getDisplayedCursor(minecraft.method_22683());
    }

    public class_1041 getWindow() {
        return minecraft.method_22683();
    }
}
