package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.mixin.WindowAccess;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11875;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

import static org.lwjgl.glfw.GLFW.*;

public sealed interface CursorRenderer {
    CursorRegistry registry();

    void applyCursor(class_1041 window);

    void resetCursor(class_1041 window);

    void render(class_1041 window, class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY);

    default Cursor getCurrentCursor(class_1041 window) {
        return registry().get(((WindowAccess) (Object) window).cursors_extended$getCurrentCursor());
    }

    record Native(CursorRegistry registry) implements CursorRenderer {
        @Override
        public void applyCursor(class_1041 window) {
            getCurrentCursor(window).cursorType().method_74032(window);
        }

        @Override
        public void resetCursor(class_1041 window) {
            window.method_74029(class_11875.field_62449);
        }

        @Override
        public void render(class_1041 window, class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            // no-op
        }
    }

    final class Virtual implements CursorRenderer {
        private final CursorRegistry registry;
        private class_2960 textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int spriteWidth;
        private int spriteHeight;
        private float drawWidth;
        private float drawHeight;
        private int vOffset;
        private float xhot;
        private float yhot;

        public Virtual(CursorRegistry registry) {
            this.registry = registry;
        }

        @Override
        public CursorRegistry registry() {
            return registry;
        }

        @Override
        public void applyCursor(class_1041 window) {
            Cursor cursor = getCurrentCursor(window);
            cursor.cursorType().method_74032(window);

            CursorTexture texture = cursor.getTexture();
            if (texture == null || !cursor.isEnabled()) {
                this.textureLocation = null;
                return;
            }

            this.textureLocation = texture.comp_3627();
            this.textureWidth = texture.textureWidth();
            this.textureHeight = texture.textureHeight();
            this.spriteWidth = texture.spriteWidth();
            this.spriteHeight = texture.spriteHeight();
            this.vOffset = texture.spriteVOffset();

            CursorProperties properties = texture instanceof CursorTexture.Stateful stateful
                    ? stateful
                    : texture.metadata().cursor();

            float scale = SettingsUtil.getAutoScale(properties.scale());
            this.xhot = properties.xhot() * scale;
            this.yhot = properties.yhot() * scale;
            this.drawWidth = this.spriteWidth * scale;
            this.drawHeight = this.spriteHeight * scale;
        }

        @Override
        public void resetCursor(class_1041 window) {
            glfwSetInputMode(window.method_4490(), GLFW_CURSOR, GLFW_CURSOR_NORMAL);
            this.textureLocation = null;
        }

        @Override
        public void render(class_1041 window, class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.field_1729.method_1613()) {
                if (this.textureLocation != null) {
                    int guiScale = minecraft.method_22683().method_4495();
                    int scaledWidth = Math.round(this.drawWidth / guiScale);
                    int scaledHeight = Math.round(this.drawHeight / guiScale);
                    int x = mouseX - Math.round(this.xhot / guiScale);
                    int y = mouseY - Math.round(this.yhot / guiScale);

                    glfwSetInputMode(window.method_4490(), GLFW_CURSOR, GLFW_CURSOR_HIDDEN);

                    guiGraphics.method_71048();
                    guiGraphics.method_25302(
                            class_10799.field_56883,
                            this.textureLocation,
                            x, y,
                            0, this.vOffset,
                            scaledWidth, scaledHeight,
                            this.spriteWidth, this.spriteHeight,
                            this.textureWidth, this.textureHeight
                    );
                } else {
                    glfwSetInputMode(window.method_4490(), GLFW_CURSOR, GLFW_CURSOR_NORMAL);
                }
            }
        }
    }
}
