package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.util.DrawUtil;
import net.minecraft.class_156;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlidingBackground {
    private static final float ANIMATION_SPEED = 25;
    private final boolean outlineOnly;
    private final int color;
    private float lastY = 0;
    private long lastFrameTime = class_156.method_648();

    public ElementSlidingBackground(int color, boolean outlineOnly) {
        this.color = color;
        this.outlineOnly = outlineOnly;
    }

    public ElementSlidingBackground(int color) {
        this(color, false);
    }

    public void reset() {
        this.lastY = 0;
        this.lastFrameTime = class_156.method_648();
    }

    public void render(@NotNull class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        long now = class_156.method_648();
        float deltaTime = (now - this.lastFrameTime) / 1_000_000_000f;
        this.lastFrameTime = now;

        this.lastY = this.lastY == 0 ? y : this.lastY;

        if (Math.abs(this.lastY - y) < 0.5f) {
            this.lastY = y;
        } else {
            float alpha = 1f - (float) Math.exp(-ANIMATION_SPEED * deltaTime);
            this.lastY = class_3532.method_16439(alpha, this.lastY, y);
        }

        int right = x + width;
        int bottom = (int) this.lastY + height;

        if (this.outlineOnly) {
            DrawUtil.renderOutline(guiGraphics, x, (int) this.lastY, width, height, this.color);
        } else {
            guiGraphics.method_25294(x, (int) this.lastY, right, bottom, this.color);
        }
    }

    public void render(@NotNull class_332 guiGraphics, @Nullable class_8021 element, float partialTick) {
        if (element == null) {
            this.reset();
            return;
        }

        this.render(guiGraphics, element.method_46426(), element.method_46427(), element.method_25368(), element.method_25364(), partialTick);
    }
}