package io.github.fishstiz.cursors_extended.mixin.cursorprovider;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_7528;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_7528.class)
public abstract class AbstractScrollAreaMixin {
    @ModifyArg(method = "renderScrollbar", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;requestCursor(Lcom/mojang/blaze3d/platform/cursor/CursorType;)V"
    ))
    private class_11875 holdResizeNs(class_11875 cursorType) {
        if (CursorTypeUtil.nameEquals(cursorType, class_11876.field_62456)) {
            return CursorsExtended.CONFIG.isResizeScrollbarEnabled() ? CursorTypesExt.RESIZE_NS_HOLD : class_11875.field_62449;
        }
        if (CursorTypeUtil.nameEquals(cursorType, class_11876.field_62455)) {
            return CursorsExtended.CONFIG.isPointerScrollbarEnabled() ? cursorType : class_11875.field_62449;
        }
        return cursorType;
    }
}
