package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.util.NativeImageUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_2960;

public final class BasicCursorTexture extends AbstractCursorTexture implements CursorTexture.Stateful {
    private final float scale;
    private final int xhot;
    private final int yhot;
    private final int textureWidth;
    private final int textureHeight;
    private final byte[] pixels;
    private final class_2960 texturePath;
    private final CursorMetadata metadata;
    private boolean enabled;

    public BasicCursorTexture(
            class_1011 image,
            class_2960 texturePath,
            CursorMetadata metadata,
            CursorProperties settings
    ) throws IOException {
        super(image, settings);
        this.enabled = settings.enabled();
        this.scale = SettingsUtil.sanitizeScale(settings.scale());
        this.xhot = SettingsUtil.sanitizeHotspot(settings.xhot(), image.method_4307());
        this.yhot = SettingsUtil.sanitizeHotspot(settings.yhot(), image.method_4323());
        this.textureWidth = image.method_4307();
        this.textureHeight = image.method_4323();
        this.pixels = NativeImageUtil.getBytes(image);
        this.texturePath = texturePath;
        this.metadata = metadata;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public void toggle() {
        this.enabled = !enabled;
    }

    @Override
    public long handle() {
        return enabled ? super.handle() : MemoryUtil.NULL;
    }

    @Override
    public float scale() {
        return scale;
    }

    @Override
    public int xhot() {
        return xhot;
    }

    @Override
    public int yhot() {
        return yhot;
    }

    @Override
    public Boolean animated() {
        return false;
    }

    @Override
    public int textureWidth() {
        return textureWidth;
    }

    @Override
    public int textureHeight() {
        return textureHeight;
    }

    @Override
    public CursorMetadata metadata() {
        return metadata;
    }

    @Override
    public @NotNull class_2960 comp_3627() {
        return texturePath;
    }

    @Override
    public CursorTexture recreate(CursorProperties properties) throws IOException {
        try (class_1011 image = class_1011.method_49277(pixels)) {
            return new BasicCursorTexture(image, texturePath, metadata, properties);
        }
    }
}