package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NativeResource;

import java.io.IOException;
import net.minecraft.class_12079;
import net.minecraft.class_2960;

public interface CursorTexture extends class_12079.class_12081, NativeResource {
    long handle();

    int textureWidth();

    int textureHeight();

    CursorMetadata metadata();

    @Override
    default @NotNull class_2960 comp_3626() {
        return comp_3627();
    }

    default int spriteWidth() {
        return textureWidth();
    }

    default int spriteHeight() {
        return textureHeight();
    }

    default int spriteVOffset() {
        return 0;
    }

    default CursorTexture recreate(CursorProperties properties) throws IOException {
        throw new IOException("This cursor texture cannot be recreated");
    }

    interface Stateful extends CursorTexture, CursorProperties {
        void toggle();

        default void setEnabled(boolean enabled) {
            if (enabled != enabled()) {
                toggle();
            }
        }
    }
}
