package io.github.fishstiz.cursors_extended.util;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import org.lwjgl.glfw.GLFW;

import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;

public class CursorTypeUtil {
    private CursorTypeUtil() {
    }

    public static final class_1041 WINDOW = class_310.method_1551().method_22683();

    public static boolean nameEquals(class_11875 a, class_11875 b) {
        return Objects.equals(a.toString(), b.toString());
    }

    public static boolean canShift() {
        Cursor shiftCursor = CursorsExtended.getInstance().getRegistry().get(CursorTypesExt.SHIFT);
        return shiftCursor.isEnabled() &&
               CursorsExtended.CONFIG.getOrCreateSettings(shiftCursor).enabled() &&
               (class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_LEFT_SHIFT) ||
                class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_RIGHT_SHIFT));
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton(WINDOW.method_4490(), GLFW.GLFW_MOUSE_BUTTON_1) == GLFW.GLFW_PRESS;
    }

    public static boolean isHeld(class_11875 lastCursorType) {
        return CursorTypesExt.isHoldType(lastCursorType) &&
               CursorsExtended.getInstance().getRegistry().get(lastCursorType).isEnabled() &&
               CursorTypeUtil.isLeftClickHeld();
    }

    public static boolean nonDefault(class_11875 cursorType) {
        return cursorType != null && !nameEquals(cursorType, class_11875.field_62449);
    }

    public static class_11875 arrowIfDefault(class_11875 cursorType) {
        return nameEquals(cursorType, class_11875.field_62449) ? class_11876.field_62452 : cursorType;
    }

    public static boolean isHovered(class_364 guiEventListener, double mouseX, double mouseY) {
        if (guiEventListener instanceof class_339 widget) {
            return widget.field_22764 &&
                   widget.method_49606() &&
                   mouseX >= widget.method_46426() &&
                   mouseY >= widget.method_46427() &&
                   mouseX < widget.method_55442() &&
                   mouseY < widget.method_55443();
        }
        return guiEventListener.method_25405(mouseX, mouseY);
    }
}
