/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class CursorRegistry
implements ClientStartedListener {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, Cursor> external = new Object2ObjectOpenHashMap();

    @Override
    public void onClientStarted(class_310 minecraft) {
        this.register(class_11875.field_62449);
        this.registerAlias(class_11875.field_62449, class_11876.field_62452);
        this.register(class_11876.field_62455);
        this.register(CursorTypesExt.GRABBING);
        this.register(class_11876.field_62453);
        this.register(CursorTypesExt.SHIFT);
        this.register(CursorTypesExt.BUSY);
        this.register(class_11876.field_62459);
        this.register(class_11876.field_62454);
        this.register(class_11876.field_62458);
        this.register(class_11876.field_62457);
        this.register(class_11876.field_62456);
        this.register(CursorTypesExt.RESIZE_NWSE);
        this.register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(class_11875 cursorType) {
        this.registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(class_11875 cursorType, class_11875 alias) {
        this.registry.putIfAbsent(alias.toString(), this.get(cursorType));
    }

    public Cursor get(class_11875 cursorType) {
        Cursor cursor = this.registry.get(cursorType.toString());
        if (cursor == null) {
            return this.external.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", (Object)cursorType);
                return new Cursor(cursorType);
            });
        }
        return cursor;
    }

    @Nullable
    public Cursor tryGet(String cursorType) {
        Cursor cursor = this.registry.get(cursorType);
        return cursor != null ? cursor : this.external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        ObjectOpenHashSet cursors = new ObjectOpenHashSet();
        cursors.addAll(this.registry.values());
        cursors.addAll(this.external.values());
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet(this.registry.values());
    }
}

