/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.mixin.WindowAccess;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11875;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.lwjgl.glfw.GLFW;

public sealed interface CursorRenderer {
    public CursorRegistry registry();

    public void applyCursor(class_1041 var1);

    public void resetCursor(class_1041 var1);

    public void render(class_1041 var1, class_310 var2, class_332 var3, int var4, int var5);

    default public Cursor getCurrentCursor(class_1041 window) {
        return this.registry().get(((WindowAccess)window).cursors_extended$getCurrentCursor());
    }

    public static final class Virtual
    implements CursorRenderer {
        private final CursorRegistry registry;
        private class_2960 textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int spriteWidth;
        private int spriteHeight;
        private float drawWidth;
        private float drawHeight;
        private int vOffset;
        private float xhot;
        private float yhot;

        public Virtual(CursorRegistry registry) {
            this.registry = registry;
        }

        @Override
        public CursorRegistry registry() {
            return this.registry;
        }

        @Override
        public void applyCursor(class_1041 window) {
            CursorProperties cursorProperties;
            Cursor cursor = this.getCurrentCursor(window);
            cursor.cursorType().method_74032(window);
            CursorTexture texture = cursor.getTexture();
            if (texture == null || !cursor.isEnabled()) {
                this.textureLocation = null;
                return;
            }
            this.textureLocation = texture.comp_3627();
            this.textureWidth = texture.textureWidth();
            this.textureHeight = texture.textureHeight();
            this.spriteWidth = texture.spriteWidth();
            this.spriteHeight = texture.spriteHeight();
            this.vOffset = texture.spriteVOffset();
            if (texture instanceof CursorTexture.Stateful) {
                CursorTexture.Stateful stateful = (CursorTexture.Stateful)texture;
                cursorProperties = stateful;
            } else {
                cursorProperties = texture.metadata().cursor();
            }
            CursorProperties properties = cursorProperties;
            float scale = SettingsUtil.getAutoScale(properties.scale());
            this.xhot = (float)properties.xhot() * scale;
            this.yhot = (float)properties.yhot() * scale;
            this.drawWidth = (float)this.spriteWidth * scale;
            this.drawHeight = (float)this.spriteHeight * scale;
        }

        @Override
        public void resetCursor(class_1041 window) {
            GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212993);
            this.textureLocation = null;
        }

        @Override
        public void render(class_1041 window, class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.field_1729.method_1613()) {
                if (this.textureLocation != null) {
                    int guiScale = minecraft.method_22683().method_4495();
                    int scaledWidth = Math.round(this.drawWidth / (float)guiScale);
                    int scaledHeight = Math.round(this.drawHeight / (float)guiScale);
                    int x = mouseX - Math.round(this.xhot / (float)guiScale);
                    int y = mouseY - Math.round(this.yhot / (float)guiScale);
                    GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212994);
                    guiGraphics.method_71048();
                    guiGraphics.method_25302(class_10799.field_56883, this.textureLocation, x, y, 0.0f, (float)this.vOffset, scaledWidth, scaledHeight, this.spriteWidth, this.spriteHeight, this.textureWidth, this.textureHeight);
                } else {
                    GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212993);
                }
            }
        }
    }

    public record Native(CursorRegistry registry) implements CursorRenderer
    {
        @Override
        public void applyCursor(class_1041 window) {
            this.getCurrentCursor(window).cursorType().method_74032(window);
        }

        @Override
        public void resetCursor(class_1041 window) {
            window.method_74029(class_11875.field_62449);
        }

        @Override
        public void render(class_1041 window, class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
        }
    }
}

