/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="doublejump", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue DOUBLE_JUMP_COOLDOWN = BUILDER.comment("Cooldown in ticks between double jumps (20 ticks = 1 second)").defineInRange("doubleJumpCooldown", 40, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue MAX_JUMPS = BUILDER.comment("Maximum number of jumps a player can perform before landing").defineInRange("maxJumps", 2, 1, 10);
    public static int doubleJumpCooldown;
    public static int maxJumps;
    public static ForgeConfigSpec SPEC;
    public static ModConfig modConfig;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("doublejump")) {
            modConfig = event.getConfig();
            Config.load();
        }
    }

    public static void load() {
        doubleJumpCooldown = (Integer)DOUBLE_JUMP_COOLDOWN.get();
        maxJumps = (Integer)MAX_JUMPS.get();
    }

    public static void setDoubleJumpCooldown(int value) {
        DOUBLE_JUMP_COOLDOWN.set((Object)value);
        doubleJumpCooldown = value;
    }

    public static void setMaxJumps(int value) {
        MAX_JUMPS.set((Object)value);
        maxJumps = value;
    }

    static {
        SPEC = BUILDER.build();
    }
}

