/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.Config;
import com.example.examplemod.DoubleJumpConfigScreen;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="doublejump")
public class ExampleMod {
    public static final String MODID = "doublejump";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ExampleMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModList.get().getModContainerById(MODID).ifPresent(modContainer -> modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new DoubleJumpConfigScreen((Screen)screen))));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        Config.load();
    }

    @Mod.EventBusSubscriber(modid="doublejump", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientModEvents {
        private static final Map<UUID, Long> lastJumpTime = new HashMap<UUID, Long>();
        private static final Map<UUID, Integer> jumpsPerformed = new HashMap<UUID, Integer>();
        private static final Map<UUID, Boolean> previousJumpState = new HashMap<UUID, Boolean>();

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase != TickEvent.Phase.END || !event.player.m_9236_().f_46443_ || !((player = event.player) instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer player2 = (LocalPlayer)player;
            UUID playerId = player2.m_20148_();
            boolean isJumping = player2.f_108618_.f_108572_;
            boolean wasJumping = previousJumpState.getOrDefault(playerId, false);
            boolean jumpPressedThisTick = isJumping && !wasJumping;
            previousJumpState.put(playerId, isJumping);
            if (player2.m_20096_()) {
                jumpsPerformed.put(playerId, 0);
                lastJumpTime.remove(playerId);
                return;
            }
            long currentTime = player2.m_9236_().m_46467_();
            int currentJumps = jumpsPerformed.getOrDefault(playerId, 0);
            long lastJump = lastJumpTime.getOrDefault(playerId, 0L);
            if (jumpPressedThisTick && currentJumps < Config.maxJumps && currentTime - lastJump >= (long)Config.doubleJumpCooldown) {
                player2.m_20334_(player2.m_20184_().f_82479_, (double)0.42f, player2.m_20184_().f_82481_);
                player2.f_19789_ = 0.0f;
                jumpsPerformed.put(playerId, currentJumps + 1);
                lastJumpTime.put(playerId, currentTime);
            }
        }
    }
}

