/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.misc;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.config.ItemEditConfig;
import me.drex.essentials.util.StyledInputUtil;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ItemEditCommand
extends Command {
    public ItemEditCommand() {
        super(CommandProperties.create("itemedit", 2));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        ((LiteralArgumentBuilder)literal.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(this.require("name"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.editItemName((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), false)))).then(class_2170.method_9247((String)"clear").executes(context -> this.editItemName((class_2168)context.getSource(), "", true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lore").requires(this.require("lore"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1, (int)ItemEditCommand.config().itemEdit.lore.maxLines)).then(class_2170.method_9244((String)"lore", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.editItemLore((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"line"), StringArgumentType.getString((CommandContext)context, (String)"lore"), false)))).then(class_2170.method_9247((String)"clear").executes(context -> this.editItemLore((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"line"), "", true)))));
    }

    protected int editItemName(class_2168 src, String name, boolean clear) throws CommandSyntaxException {
        class_3222 player = src.method_9207();
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.missing"));
            return 0;
        }
        ItemEditConfig.NameConfig nameConfig = ItemEditCommand.config().itemEdit.name;
        class_2561 parsed = StyledInputUtil.parse(name, src, "style.item.name.");
        class_5250 component = parsed.getString().equals(name) ? class_2561.method_43470((String)name) : (class_5250)parsed;
        if (parsed.getString().length() > nameConfig.maxLength) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.name.length"));
            return 0;
        }
        if (player.field_7520 >= nameConfig.experienceLevelCost || player.method_68878()) {
            if (!player.method_68878()) {
                player.method_7316(-nameConfig.experienceLevelCost);
            }
            if (clear) {
                itemStack.method_57379(class_9334.field_49631, null);
            } else {
                itemStack.method_57379(class_9334.field_49631, (Object)component.method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            }
            src.method_9226(() -> LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.name", Map.of("name", itemStack.method_7964())), false);
            return 1;
        }
        src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.experience"));
        return 0;
    }

    protected int editItemLore(class_2168 src, int line, String lore, boolean clear) throws CommandSyntaxException {
        class_3222 player = src.method_9207();
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.missing"));
            return 0;
        }
        ItemEditConfig.LoreConfig loreConfig = ItemEditCommand.config().itemEdit.lore;
        class_2561 parsed = StyledInputUtil.parse(lore, src, "style.item.lore.");
        class_5250 component = parsed.getString().equals(lore) ? class_2561.method_43470((String)lore) : (class_5250)parsed;
        if (parsed.getString().length() > loreConfig.maxLength) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.lore.length"));
            return 0;
        }
        if (player.field_7520 >= loreConfig.experienceLevelCost || player.method_68878()) {
            if (!player.method_68878()) {
                player.method_7316(-loreConfig.experienceLevelCost);
            }
            AtomicInteger result = new AtomicInteger();
            itemStack.method_57368(class_9334.field_49632, (Object)class_9290.field_49340, itemLore -> {
                LinkedList<class_5250> lines = new LinkedList<class_5250>(itemLore.comp_2400());
                if (clear) {
                    if (line > lines.size()) {
                        src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.lore.invalid_line"));
                        result.set(0);
                        return itemLore;
                    }
                    lines.remove(line - 1);
                } else {
                    for (int i = itemLore.comp_2400().size(); i <= line - 1; ++i) {
                        lines.add(class_2561.method_43473());
                    }
                    lines.set(line - 1, component.method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068)));
                }
                src.method_9226(() -> LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.lore", Map.of("line", class_2561.method_43470((String)String.valueOf(line)), "lore", component)), false);
                result.set(1);
                return new class_9290(lines);
            });
            return result.get();
        }
        src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.itemedit.experience"));
        return 0;
    }
}

