/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.config.teleportation.WaitingPeriodConfig;
import me.drex.essentials.mixin.async.IServerChunkCache;
import me.drex.essentials.util.AsyncChunkLoadUtil;
import me.drex.essentials.util.AsyncTeleportPlayer;
import me.drex.essentials.util.ComponentPlaceholderUtil;
import me.drex.essentials.util.TeleportCancelException;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_11560;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_9259;

public class CommandUtil {
    private static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.player.toomany"));
    private static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.notfound.player"));
    public static final SuggestionProvider<class_2168> PROFILES_PROVIDER = (ctx, builder) -> class_2172.method_9265((Iterable)((class_2168)ctx.getSource()).method_9262(), (SuggestionsBuilder)builder);

    public static GameProfile getGameProfile(CommandContext<class_2168> context, String argument) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)argument);
        if (profiles.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        if (profiles.size() != 1) {
            throw ERROR_NOT_SINGLE_PLAYER.create();
        }
        class_11560 profile = (class_11560)profiles.iterator().next();
        return new GameProfile(profile.comp_4422(), profile.comp_4423());
    }

    public static CompletableFuture<class_2791> asyncTeleport(class_2168 src, class_3218 level, class_1923 pos, WaitingPeriodConfig config) throws CommandSyntaxException {
        AsyncTeleportPlayer asyncTeleportPlayer = (AsyncTeleportPlayer)src.method_9207();
        if (asyncTeleportPlayer.isAsyncLoadingChunks()) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.async.active"));
            return CompletableFuture.completedFuture(null);
        }
        int RADIUS = 2;
        CompletableFuture<class_2791> result = new CompletableFuture<class_2791>();
        asyncTeleportPlayer.setAsyncLoadingChunks(true);
        class_3215 chunkCache = level.method_14178();
        CompletableFuture<Void> waitFuture = asyncTeleportPlayer.delayedTeleport(src, config);
        CompletableFuture<class_9259<class_2791>> chunkAccessFuture = AsyncChunkLoadUtil.scheduleChunkLoadWithRadius(level, pos, 2);
        chunkAccessFuture.whenCompleteAsync((chunkResult, throwable) -> asyncTeleportPlayer.setAsyncLoadingChunks(false), (Executor)src.method_9211());
        waitFuture.whenCompleteAsync((unused, waitingThrowable) -> {
            if (waitingThrowable != null) {
                asyncTeleportPlayer.setAsyncLoadingChunks(false);
                if (waitingThrowable instanceof TeleportCancelException) {
                    TeleportCancelException exception = (TeleportCancelException)waitingThrowable;
                    src.method_9213(exception.getRawMessage());
                } else {
                    src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.teleport.wait.error", ComponentPlaceholderUtil.exceptionPlaceholders(waitingThrowable)));
                    EssentialsMod.LOGGER.error("An unknown error occurred, during waiting period", waitingThrowable);
                }
                result.cancel(false);
                chunkCache.method_66010(AsyncChunkLoadUtil.ASYNC_CHUNK_LOAD, pos, 2);
                ((IServerChunkCache)chunkCache).invokeRunDistanceManagerUpdates();
            } else {
                chunkAccessFuture.whenCompleteAsync((chunkResult, chunkThrowable) -> {
                    if (chunkThrowable != null) {
                        src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.async.error", ComponentPlaceholderUtil.exceptionPlaceholders(chunkThrowable)));
                        EssentialsMod.LOGGER.error("An unknown error occurred, while loading the chunks", chunkThrowable);
                        result.cancel(false);
                    } else if (chunkResult.method_57122()) {
                        result.complete((class_2791)chunkResult.method_57130(null));
                    } else {
                        src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.async.not_loaded"));
                        EssentialsMod.LOGGER.error("Chunk not there when requested: {}", (Object)chunkResult.method_57129());
                    }
                    chunkCache.method_66010(AsyncChunkLoadUtil.ASYNC_CHUNK_LOAD, pos, 2);
                    ((IServerChunkCache)chunkCache).invokeRunDistanceManagerUpdates();
                }, (Executor)src.method_9211());
            }
        }, (Executor)src.method_9211());
        return result;
    }
}

