/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.command.impl.home.DeleteHomeCommand;
import me.drex.essentials.command.impl.home.HomeCommand;
import me.drex.essentials.command.impl.home.HomesCommand;
import me.drex.essentials.command.impl.home.SetHomeCommand;
import me.drex.essentials.command.impl.menu.AnvilCommand;
import me.drex.essentials.command.impl.menu.CartographyTableCommand;
import me.drex.essentials.command.impl.menu.EnchantmentCommand;
import me.drex.essentials.command.impl.menu.EnderChestCommand;
import me.drex.essentials.command.impl.menu.GrindstoneCommand;
import me.drex.essentials.command.impl.menu.LoomCommand;
import me.drex.essentials.command.impl.menu.SmithingCommand;
import me.drex.essentials.command.impl.menu.StonecutterCommand;
import me.drex.essentials.command.impl.menu.WorkBenchCommand;
import me.drex.essentials.command.impl.misc.FeedCommand;
import me.drex.essentials.command.impl.misc.FlyCommand;
import me.drex.essentials.command.impl.misc.FlySpeedCommand;
import me.drex.essentials.command.impl.misc.GlowCommand;
import me.drex.essentials.command.impl.misc.HatCommand;
import me.drex.essentials.command.impl.misc.HealCommand;
import me.drex.essentials.command.impl.misc.InvulnerableCommand;
import me.drex.essentials.command.impl.misc.ItemEditCommand;
import me.drex.essentials.command.impl.misc.PingCommand;
import me.drex.essentials.command.impl.misc.RepairCommand;
import me.drex.essentials.command.impl.misc.SignEditCommand;
import me.drex.essentials.command.impl.misc.WalkSpeedCommand;
import me.drex.essentials.command.impl.misc.WhoIsCommand;
import me.drex.essentials.command.impl.misc.admin.BroadcastCommand;
import me.drex.essentials.command.impl.misc.admin.CommandSpyCommand;
import me.drex.essentials.command.impl.misc.admin.EssentialsCommand;
import me.drex.essentials.command.impl.misc.admin.MessageToVanilla;
import me.drex.essentials.command.impl.misc.admin.ModsCommand;
import me.drex.essentials.command.impl.misc.admin.TellMessageCommand;
import me.drex.essentials.command.impl.teleportation.BackCommand;
import me.drex.essentials.command.impl.tpa.TpAcceptCommand;
import me.drex.essentials.command.impl.tpa.TpAllCommand;
import me.drex.essentials.command.impl.tpa.TpDenyCommand;
import me.drex.essentials.command.impl.tpa.TpaCommand;
import me.drex.essentials.command.impl.warp.DeleteWarpCommand;
import me.drex.essentials.command.impl.warp.SetWarpCommand;
import me.drex.essentials.command.impl.warp.WarpCommand;
import me.drex.essentials.command.impl.warp.WarpsCommand;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class CommandManager {
    private static final boolean DUMP_COMMANDS = false;
    public static final Command[] COMMANDS = new Command[]{new AnvilCommand(), new CartographyTableCommand(), new EnchantmentCommand(), new EnderChestCommand(), new GrindstoneCommand(), new LoomCommand(), new SmithingCommand(), new StonecutterCommand(), new WorkBenchCommand(), new DeleteHomeCommand(), new HomeCommand(), new HomesCommand(), new SetHomeCommand(), new DeleteWarpCommand(), new WarpCommand(), new SetWarpCommand(), new WarpsCommand(), TpaCommand.TPA, TpaCommand.TPA_HERE, new TpAllCommand(), new TpAcceptCommand(), new TpDenyCommand(), new BackCommand(), new BroadcastCommand(), new CommandSpyCommand(), new EssentialsCommand(), new FeedCommand(), new HatCommand(), new ItemEditCommand(), new HealCommand(), new GlowCommand(), new PingCommand(), new RepairCommand(), new SignEditCommand(), new ModsCommand(), new FlyCommand(), new FlySpeedCommand(), new WalkSpeedCommand(), new WhoIsCommand(), new InvulnerableCommand(), new TellMessageCommand(), new MessageToVanilla()};

    public CommandManager(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        for (Command command : COMMANDS) {
            command.register(dispatcher, context);
        }
    }

    public static void dumpCommands(CommandDispatcher<class_2168> dispatcher, MinecraftServer server) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        class_2168 source = server.method_3739();
        StringBuilder builder = new StringBuilder();
        builder.append("| Command | Alias | Permission | Default |\n").append("|---|---|---|---|\n");
        for (Command command : COMMANDS) {
            CommandProperties properties = command.commandProperties;
            builder.append("| ");
            ParseResults parseResults = dispatcher.parse(properties.literal(), (Object)source);
            Map map = dispatcher.getSmartUsage(((ParsedCommandNode)Iterables.getLast((Iterable)parseResults.getContext().getNodes())).getNode(), (Object)source);
            if (map.isEmpty()) {
                builder.append("`/").append(properties.literal()).append('`');
            } else {
                builder.append(String.join((CharSequence)", ", map.values().stream().map(s -> "`/" + properties.literal() + " " + s.replace("|", "\\|") + "`").toList()));
            }
            builder.append(" | ");
            builder.append(String.join((CharSequence)", ", Arrays.stream(properties.alias()).map(s -> "`/" + s + "`").toList()));
            builder.append(" | ");
            builder.append("`fabric-essentials.command.").append(properties.literal()).append('`');
            builder.append(" | ");
            if (properties.defaultRequiredLevel() <= 0) {
                builder.append('\u2714');
            } else {
                builder.append('\u2718');
            }
            builder.append(" |\n");
        }
        try {
            Files.write(FabricLoader.getInstance().getGameDir().getParent().getParent().getParent().resolve("COMMANDS.md"), builder.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

