/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.home;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.concurrent.Executor;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.command.util.CommandUtil;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.util.teleportation.Home;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class HomeCommand
extends Command {
    public static final SimpleCommandExceptionType UNKNOWN = new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"fabric-essentials.commands.home.unknown"));
    public static final String DEFAULT_HOME_NAME = "home";
    public static final SuggestionProvider<class_2168> HOMES_PROVIDER = (ctx, builder) -> {
        PlayerData playerData = DataStorage.getPlayerData((CommandContext<class_2168>)ctx);
        return class_2172.method_9265(playerData.homes.keySet(), (SuggestionsBuilder)builder);
    };

    public HomeCommand() {
        super(CommandProperties.create(DEFAULT_HOME_NAME, 0));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        ((LiteralArgumentBuilder)literal.then(((RequiredArgumentBuilder)class_2170.method_9244((String)DEFAULT_HOME_NAME, (ArgumentType)StringArgumentType.word()).suggests(HOMES_PROVIDER).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).suggests(CommandUtil.PROFILES_PROVIDER).requires(this.require("other"))).executes(ctx -> this.teleportHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)DEFAULT_HOME_NAME), CommandUtil.getGameProfile((CommandContext<class_2168>)ctx, "player"), false)))).executes(ctx -> this.teleportHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)DEFAULT_HOME_NAME), ((class_2168)ctx.getSource()).method_9207().method_7334(), true)))).executes(ctx -> this.teleportHome((class_2168)ctx.getSource(), DEFAULT_HOME_NAME, ((class_2168)ctx.getSource()).method_9207().method_7334(), true));
    }

    protected int teleportHome(class_2168 src, String name, GameProfile target, boolean self) throws CommandSyntaxException {
        class_3222 serverPlayer = src.method_9207();
        PlayerData playerData = DataStorage.getOfflinePlayerData(src.method_9211(), target);
        Home home = playerData.homes.get(name);
        if (home == null) {
            throw UNKNOWN.create();
        }
        class_3218 targetLevel = home.location().getLevel(src.method_9211());
        if (targetLevel != null) {
            CommandUtil.asyncTeleport(src, targetLevel, home.location().chunkPos(), HomeCommand.config().teleportation.waitingPeriod).whenCompleteAsync((chunkAccess, throwable) -> {
                if (chunkAccess == null) {
                    return;
                }
                if (self) {
                    src.method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.home.self", home.placeholders(name)));
                } else {
                    src.method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.home.other", home.placeholders(name), (PlaceholderContext)PlaceholderContext.of((GameProfile)target, (MinecraftServer)src.method_9211())));
                }
                home.location().teleport((class_1297)serverPlayer);
            }, (Executor)src.method_9211());
            return 1;
        }
        throw WORLD_UNKNOWN.create();
    }
}

