/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.misc.admin;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.command.impl.misc.admin.importer.DataImporter;
import me.drex.essentials.command.impl.misc.admin.importer.EssentialCommandsImporter;
import me.drex.essentials.command.impl.misc.admin.importer.KiloEssentialsImporter;
import me.drex.essentials.config.ConfigManager;
import me.drex.essentials.mixin.CommandSourceStackAccessor;
import me.drex.message.api.LocalizedMessage;
import me.drex.message.api.MessageAPI;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.apache.commons.lang3.time.StopWatch;

public class EssentialsCommand
extends Command {
    public static final SimpleCommandExceptionType UNKNOWN = new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"fabric-essentials.commands.essentials.import.unknown"));
    private static final DataImporter[] DATA_IMPORTERS = new DataImporter[]{KiloEssentialsImporter.KILO_ESSENTIALS, EssentialCommandsImporter.ESSENTIAL_COMMANDS};
    public static final SuggestionProvider<class_2168> IMPORTER_PROVIDER = (ctx, builder) -> class_2172.method_9264(Arrays.stream(DATA_IMPORTERS).map(DataImporter::getImporterId), (SuggestionsBuilder)builder);

    public EssentialsCommand() {
        super(CommandProperties.create("essentials", 3));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        ((LiteralArgumentBuilder)literal.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(this.require("reload"))).executes(this::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"import").requires(this.require("import"))).then(class_2170.method_9244((String)"importer", (ArgumentType)StringArgumentType.string()).suggests(IMPORTER_PROVIDER).executes(this::importData)));
    }

    private int reload(CommandContext<class_2168> ctx) {
        final StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (!ConfigManager.load()) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.essentials.reload.error"));
            return 0;
        }
        MessageAPI.reload();
        stopWatch.stop();
        ((class_2168)ctx.getSource()).method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.essentials.reload", (Map)new HashMap<String, class_2561>(){
            {
                this.put("time", class_2561.method_43470((String)String.valueOf(stopWatch.getTime())));
            }
        }));
        return 1;
    }

    private int importData(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        if (!((CommandSourceStackAccessor)ctx.getSource()).getSource().equals((Object)((class_2168)ctx.getSource()).method_9211())) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.essentials.import.console"));
            return 0;
        }
        String importerId = StringArgumentType.getString(ctx, (String)"importer");
        Optional<DataImporter> optional = Arrays.stream(DATA_IMPORTERS).filter(importer -> importer.getImporterId().equals(importerId)).findFirst();
        DataImporter dataImporter = optional.orElseThrow(() -> ((SimpleCommandExceptionType)UNKNOWN).create());
        dataImporter.importData(((class_2168)ctx.getSource()).method_9211());
        return 1;
    }
}

