/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import eu.pb4.playerdata.impl.BaseGson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    public static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    public static final Path CONFIG_FILE = CONFIG_DIR.resolve("fabric-essentials.json");
    private static final Gson GSON = BaseGson.createBuilder().setPrettyPrinting().create();
    private static Config config = new Config();

    public static boolean load() {
        EssentialsMod.LOGGER.info("Loading essentials config");
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try {
                String data = Files.readString(CONFIG_FILE);
                try {
                    config = (Config)GSON.fromJson(data, Config.class);
                    return true;
                }
                catch (JsonSyntaxException e) {
                    EssentialsMod.LOGGER.error("Failed to parse essentials config", (Throwable)e);
                }
            }
            catch (IOException e) {
                EssentialsMod.LOGGER.error("Failed to load essentials config", (Throwable)e);
            }
        } else {
            try {
                Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
                return true;
            }
            catch (IOException e) {
                EssentialsMod.LOGGER.error("Failed to save essentials config", (Throwable)e);
            }
        }
        return false;
    }

    public static Config config() {
        return config;
    }
}

