/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.mixin.async;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.drex.essentials.config.teleportation.WaitingPeriodConfig;
import me.drex.essentials.util.AsyncTeleportPlayer;
import me.drex.essentials.util.PermissionUtil;
import me.drex.essentials.util.TeleportCancelException;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements AsyncTeleportPlayer {
    @Shadow
    @Final
    MinecraftServer field_13995;
    private CompletableFuture<Void> waitingPeriodFuture = CompletableFuture.completedFuture(null);
    private int waitingPeriodTicks = 0;
    @Nullable
    private WaitingPeriodConfig waitingPeriodConfig = null;
    private boolean asyncLoadingChunks = false;
    private class_2168 waitingPeriodSource = null;

    public ServerPlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Shadow
    public abstract void method_64398(class_2561 var1);

    @Shadow
    public abstract void method_43502(class_2561 var1, boolean var2);

    @Override
    public CompletableFuture<Void> delayedTeleport(@NotNull class_2168 originalSource, @NotNull WaitingPeriodConfig context) {
        return this.delayedTeleport(originalSource, context.period * 20, context);
    }

    @Override
    public CompletableFuture<Void> delayedTeleport(@NotNull class_2168 originalSource, int waitingTicks, @Nullable WaitingPeriodConfig context) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.waitingPeriodFuture = future;
        this.waitingPeriodTicks = waitingTicks;
        this.waitingPeriodConfig = context;
        this.waitingPeriodSource = originalSource;
        return future;
    }

    @Override
    public void cancelDelayedTeleport(TeleportCancelException cancelException) {
        this.waitingPeriodTicks = -1;
        this.waitingPeriodSource = null;
        this.waitingPeriodFuture.completeExceptionally(cancelException);
    }

    @Override
    public boolean isAsyncLoadingChunks() {
        return this.asyncLoadingChunks;
    }

    @Override
    public void setAsyncLoadingChunks(boolean loadingChunks) {
        this.asyncLoadingChunks = loadingChunks;
        if (!loadingChunks) {
            this.method_43502((class_2561)class_2561.method_43473(), true);
            this.method_43502((class_2561)LocalizedMessage.localized((String)"fabric-essentials.async.loading_chunks.done"), true);
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        if (this.isAsyncLoadingChunks()) {
            String key = String.valueOf(this.field_13995.method_3780() / 6 % 3);
            this.method_43502((class_2561)LocalizedMessage.localized((String)("fabric-essentials.async.loading_chunks." + key)), true);
        }
        if (this.waitingPeriodTicks >= 0) {
            if (this.waitingPeriodTicks == 0) {
                this.waitingPeriodFuture.complete(null);
            } else {
                if (this.waitingPeriodConfig != null) {
                    WaitingPeriodConfig.CancellationConfig cancellation = this.waitingPeriodConfig.cancellation;
                    double distance = this.waitingPeriodSource.method_9222().method_1022(this.method_73189());
                    class_3222 player = (class_3222)this;
                    if (cancellation.maxMoveDistance >= 0 && distance >= (double)cancellation.maxMoveDistance && !PermissionUtil.check(player, "teleport.cancel.bypass.move")) {
                        this.cancelDelayedTeleport(new TeleportCancelException(WaitingPeriodConfig.WaitingResult.MOVE.component()));
                        return;
                    }
                    if (cancellation.damage && this.method_6081() != null && !PermissionUtil.check(player, "teleport.cancel.bypass.damage")) {
                        this.cancelDelayedTeleport(new TeleportCancelException(WaitingPeriodConfig.WaitingResult.DAMAGE.component()));
                        return;
                    }
                    if (this.field_13995.method_3760().method_14602(this.method_5667()) == null) {
                        this.cancelDelayedTeleport(new TeleportCancelException(WaitingPeriodConfig.WaitingResult.UNKNOWN.component()));
                        return;
                    }
                }
                if (this.waitingPeriodTicks % 20 == 0) {
                    final int ceilDiv = -Math.floorDiv(-this.waitingPeriodTicks, 20);
                    this.method_64398((class_2561)LocalizedMessage.localized((String)"fabric-essentials.teleport.wait", (Map)new HashMap<String, class_2561>(){
                        {
                            this.put("time", class_2561.method_43470((String)String.valueOf(ceilDiv)));
                        }
                    }));
                }
            }
            --this.waitingPeriodTicks;
        }
    }
}

