/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.misc.admin;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.util.ComponentPlaceholderUtil;
import me.drex.message.api.LocalizedMessage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ModsCommand
extends Command {
    public static final SimpleCommandExceptionType UNKNOWN = new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"fabric-essentials.commands.mods.mod.unknown"));
    public static final SuggestionProvider<class_2168> MODS_PROVIDER = (ctx, builder) -> class_2172.method_9264(FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()), (SuggestionsBuilder)builder);

    public ModsCommand() {
        super(CommandProperties.create("mods", 2));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        ((LiteralArgumentBuilder)literal.then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(MODS_PROVIDER).executes(this::sendModInfo))).executes(this::sendModList);
    }

    private int sendModList(CommandContext<class_2168> ctx) {
        final List<ModContainer> mods = FabricLoader.getInstance().getAllMods().stream().filter(modContainer -> modContainer.getOrigin().getKind() == ModOrigin.Kind.PATH).toList();
        class_5250 modsList = class_2564.method_36332(mods, (class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.mods.list.separator"), mod -> LocalizedMessage.localized((String)"fabric-essentials.commands.mods.list.element", ComponentPlaceholderUtil.modPlaceholders(mod)));
        ((class_2168)ctx.getSource()).method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.mods", (Map)new HashMap<String, class_2561>((class_2561)modsList){
            final /* synthetic */ class_2561 val$modsList;
            {
                this.val$modsList = class_25612;
                this.put("mod_count", class_2561.method_43470((String)String.valueOf(mods.size())));
                this.put("mod_list", this.val$modsList);
            }
        }));
        return mods.size();
    }

    private int sendModInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        Optional optional = FabricLoader.getInstance().getModContainer(modId);
        if (optional.isPresent()) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.mods.mod", ComponentPlaceholderUtil.modPlaceholders((ModContainer)optional.get())));
            return 1;
        }
        throw UNKNOWN.create();
    }
}

