/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.teleportation;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.config.ConfigManager;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.util.teleportation.Location;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BackCommand
extends Command {
    public BackCommand() {
        super(CommandProperties.create("back", 2));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        literal.executes(this::teleportBack);
    }

    private int teleportBack(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 target = source.method_9207();
        PlayerData playerData = DataStorage.getPlayerData(target);
        if (playerData.teleportLocations.isEmpty()) {
            source.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.back.empty"));
            return 0;
        }
        Location location = playerData.teleportLocations.pop();
        source.method_45068((class_2561)LocalizedMessage.builder((String)"fabric-essentials.commands.back").addPlaceholders(location.placeholders()).build());
        location.teleport((class_1297)target, ConfigManager.config().teleportation.saveBackCommandLocation);
        return 1;
    }
}

