/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.function.Predicate;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.config.Config;
import me.drex.essentials.config.ConfigManager;
import me.drex.essentials.util.IdentifierUtil;
import me.drex.message.api.LocalizedMessage;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Command {
    protected final CommandProperties commandProperties;
    protected static final Logger LOGGER = EssentialsMod.LOGGER;
    public static final SimpleCommandExceptionType WORLD_UNKNOWN = new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"fabric-essentials.location.world.unknown"));
    public static final int SUCCESS = 1;
    public static final int FAILURE = 0;

    public Command(@NotNull CommandProperties commandProperties) {
        this.commandProperties = commandProperties;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        String[] aliasLiterals = this.commandProperties.alias();
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)this.commandProperties.literal()).requires(this.require(null, this.commandProperties.defaultRequiredLevel()));
        this.registerArguments((LiteralArgumentBuilder<class_2168>)builder, context);
        LiteralCommandNode root = dispatcher.register(builder);
        for (String aliasLiteral : aliasLiterals) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)aliasLiteral).requires(builder.getRequirement())).executes(builder.getCommand())).redirect((CommandNode)root));
        }
    }

    protected abstract void registerArguments(LiteralArgumentBuilder<class_2168> var1, class_7157 var2);

    public Predicate<class_2168> require(@Nullable String permission) {
        return this.require(permission, 2);
    }

    public Predicate<class_2168> require(@Nullable String permission, int defaultRequiredLevel) {
        return src -> {
            try {
                return Permissions.check((class_2172)src, (String)this.permission(permission), (int)defaultRequiredLevel);
            }
            catch (Throwable ignored) {
                return src.method_9259(defaultRequiredLevel);
            }
        };
    }

    public Predicate<class_2168> require(@Nullable String permission, boolean fallback) {
        return src -> {
            try {
                return Permissions.check((class_2172)src, (String)this.permission(permission), (boolean)fallback);
            }
            catch (Throwable ignored) {
                return fallback;
            }
        };
    }

    public boolean check(class_2168 src, String permission) {
        return this.require(permission).test(src);
    }

    public boolean check(class_2168 src, String permission, int defaultRequiredLevel) {
        return this.require(permission, defaultRequiredLevel).test(src);
    }

    public boolean check(class_2168 src, String permission, boolean fallback) {
        return this.require(permission, fallback).test(src);
    }

    public String permission(@Nullable String permission) {
        if (permission == null) {
            return IdentifierUtil.permission("command." + this.commandProperties.literal());
        }
        return IdentifierUtil.permission("command." + this.commandProperties.literal() + "." + permission);
    }

    public CommandProperties defaultProperties() {
        return this.commandProperties;
    }

    public static Config config() {
        return ConfigManager.config();
    }
}

