/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.misc.admin.importer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.command.impl.misc.admin.importer.DataImporter;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.storage.ServerData;
import me.drex.essentials.util.teleportation.Home;
import me.drex.essentials.util.teleportation.Location;
import me.drex.essentials.util.teleportation.Warp;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class EssentialCommandsImporter
implements DataImporter {
    public static final EssentialCommandsImporter ESSENTIAL_COMMANDS = new EssentialCommandsImporter();

    @Override
    public String getImporterId() {
        return "essential_commands";
    }

    @Override
    public void importData(MinecraftServer server) {
        Path worldPath = server.method_27050(class_5218.field_24188);
        Path modPlayerData = worldPath.resolve("modplayerdata");
        if (Files.exists(modPlayerData, new LinkOption[0])) {
            try {
                AtomicInteger success = new AtomicInteger(0);
                AtomicInteger failures = new AtomicInteger(0);
                Files.list(modPlayerData).forEach(path -> {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        try {
                            boolean shouldSave = false;
                            UUID uuid = UUID.fromString(path.getFileName().toString().replace(".dat", ""));
                            PlayerData playerData = DataStorage.getOfflinePlayerData(server, uuid);
                            class_2487 tag = class_2507.method_10629((InputStream)Files.newInputStream(path, new OpenOption[0]), (class_2505)class_2505.method_53898());
                            HashMap<String, Home> homes = new HashMap<String, Home>();
                            class_2487 data = tag.method_10562("data");
                            class_2487 homesData = data.method_10562("homes");
                            for (String homeName : homesData.method_10541()) {
                                class_2487 home = homesData.method_10562(homeName);
                                String world = home.method_10558("WorldRegistryKey");
                                double x = home.method_10574("x");
                                double y = home.method_10574("y");
                                double z = home.method_10574("z");
                                float yaw = home.method_10583("headYaw");
                                float pitch = home.method_10583("pitch");
                                homes.put(homeName, new Home(new Location(new class_243(x, y, z), yaw, pitch, class_2960.method_60654((String)world))));
                            }
                            if (!homes.isEmpty()) {
                                shouldSave = true;
                                playerData.homes.putAll(homes);
                            }
                            if (shouldSave) {
                                DataStorage.updateOfflinePlayerData(server, uuid, playerData);
                            }
                            success.incrementAndGet();
                        }
                        catch (Exception e) {
                            EssentialsMod.LOGGER.error("An error occurred while handling user file {}", path, (Object)e);
                            failures.incrementAndGet();
                        }
                    }
                });
                EssentialsMod.LOGGER.info("User data imported, {} successful, {} failed!", (Object)success.get(), (Object)failures.get());
            }
            catch (IOException e) {
                EssentialsMod.LOGGER.error("Failed to import player data", (Throwable)e);
            }
        } else {
            EssentialsMod.LOGGER.error("User directory ({}) doesn't exist", (Object)modPlayerData);
        }
        Path essentialCommands = worldPath.resolve("essentialcommands");
        if (Files.exists(essentialCommands, new LinkOption[0])) {
            Path worldData = essentialCommands.resolve("world_data.dat");
            if (Files.exists(worldData, new LinkOption[0])) {
                try {
                    class_2487 tag = class_2507.method_10629((InputStream)Files.newInputStream(worldData, new OpenOption[0]), (class_2505)class_2505.method_53898());
                    HashMap<String, Warp> warps = new HashMap<String, Warp>();
                    class_2487 data = tag.method_10562("data");
                    class_2487 warpsData = data.method_10562("warps");
                    for (String homeName : warpsData.method_10541()) {
                        class_2487 home = warpsData.method_10562(homeName);
                        String world = home.method_10558("WorldRegistryKey");
                        double x = home.method_10574("x");
                        double y = home.method_10574("y");
                        double z = home.method_10574("z");
                        float yaw = home.method_10583("headYaw");
                        float pitch = home.method_10583("pitch");
                        warps.put(homeName, new Warp(new Location(new class_243(x, y, z), yaw, pitch, class_2960.method_60654((String)world))));
                    }
                    ServerData serverData = DataStorage.serverData();
                    serverData.getWarps().putAll(warps);
                    EssentialsMod.LOGGER.info("Warps data imported, imported {} warps!", (Object)warps.size());
                }
                catch (IOException e) {
                    EssentialsMod.LOGGER.error("An error occurred while handling the server file {}", (Object)worldData, (Object)e);
                }
            } else {
                EssentialsMod.LOGGER.error("Server data ({}) doesn't exist", (Object)worldData);
            }
        } else {
            EssentialsMod.LOGGER.error("Server data directory ({}) doesn't exist", (Object)essentialCommands);
        }
    }
}

