/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.storage;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.JsonDataStorage;
import eu.pb4.playerdata.impl.BaseGson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.UUID;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.storage.ServerData;
import me.drex.essentials.storage.adapter.Vec3Adapter;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DataStorage {
    public static final Gson GSON = BaseGson.createBuilder().registerTypeAdapter(class_243.class, (Object)new Vec3Adapter()).create();
    public static final File FABRIC_ESSENTIALS_DATA = new File("fabric-essentials.json");
    public static final JsonDataStorage<PlayerData> USER_DATA_STORAGE = new JsonDataStorage("fabric-essentials", PlayerData.class, GSON);
    private static ServerData serverData = new ServerData();

    private DataStorage() {
    }

    @ApiStatus.Internal
    public static void init() {
        PlayerDataApi.register(USER_DATA_STORAGE);
        ServerLifecycleEvents.SERVER_STARTING.register(DataStorage::load);
        ServerLifecycleEvents.BEFORE_SAVE.register((server, flush, force) -> DataStorage.save());
    }

    @NotNull
    public static ServerData serverData() {
        return serverData;
    }

    private static void load(MinecraftServer server) {
        if (FABRIC_ESSENTIALS_DATA.exists()) {
            try {
                String json = Files.readString(FABRIC_ESSENTIALS_DATA.toPath());
                ServerData essentialsData = (ServerData)GSON.fromJson(json, ServerData.class);
                serverData = Objects.requireNonNullElseGet(essentialsData, ServerData::new);
            }
            catch (IOException e) {
                EssentialsMod.LOGGER.error("Couldn't load server data", (Throwable)e);
            }
        }
    }

    @ApiStatus.Internal
    public static void save() {
        try {
            Files.writeString(FABRIC_ESSENTIALS_DATA.toPath(), (CharSequence)GSON.toJson((Object)serverData), new OpenOption[0]);
        }
        catch (IOException e) {
            EssentialsMod.LOGGER.error("Couldn't save server data", (Throwable)e);
        }
    }

    @NotNull
    public static PlayerData getPlayerData(class_3222 player) {
        PlayerData playerData = (PlayerData)PlayerDataApi.getCustomDataFor((class_3222)player, USER_DATA_STORAGE);
        if (playerData == null) {
            playerData = new PlayerData();
        }
        return playerData;
    }

    @NotNull
    public static PlayerData updatePlayerData(class_3222 player) {
        PlayerData playerData = (PlayerData)PlayerDataApi.getCustomDataFor((class_3222)player, USER_DATA_STORAGE);
        if (playerData == null) {
            playerData = new PlayerData();
            PlayerDataApi.setCustomDataFor((class_3222)player, USER_DATA_STORAGE, (Object)playerData);
        }
        return playerData;
    }

    @NotNull
    public static PlayerData getPlayerData(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return DataStorage.getOfflinePlayerData(((class_2168)ctx.getSource()).method_9211(), ((class_2168)ctx.getSource()).method_9207().method_5667());
    }

    @NotNull
    public static PlayerData getOfflinePlayerData(MinecraftServer server, GameProfile profile) {
        PlayerData playerData = (PlayerData)PlayerDataApi.getCustomDataFor((MinecraftServer)server, (UUID)profile.getId(), USER_DATA_STORAGE);
        if (playerData == null) {
            playerData = new PlayerData();
        }
        return playerData;
    }

    @NotNull
    public static PlayerData getOfflinePlayerData(MinecraftServer server, UUID uuid) {
        PlayerData playerData = (PlayerData)PlayerDataApi.getCustomDataFor((MinecraftServer)server, (UUID)uuid, USER_DATA_STORAGE);
        if (playerData == null) {
            playerData = new PlayerData();
        }
        return playerData;
    }

    public static void updateOfflinePlayerData(MinecraftServer server, GameProfile profile, PlayerData playerData) {
        PlayerDataApi.setCustomDataFor((MinecraftServer)server, (UUID)profile.getId(), USER_DATA_STORAGE, (Object)playerData);
    }

    public static void updateOfflinePlayerData(MinecraftServer server, UUID uuid, PlayerData playerData) {
        PlayerDataApi.setCustomDataFor((MinecraftServer)server, (UUID)uuid, USER_DATA_STORAGE, (Object)playerData);
    }
}

