/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.misc.admin.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.drex.essentials.EssentialsMod;
import me.drex.essentials.command.impl.misc.admin.importer.DataImporter;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.storage.ServerData;
import me.drex.essentials.util.teleportation.Home;
import me.drex.essentials.util.teleportation.Location;
import me.drex.essentials.util.teleportation.Warp;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class KiloEssentialsImporter
implements DataImporter {
    public static final KiloEssentialsImporter KILO_ESSENTIALS = new KiloEssentialsImporter();

    private KiloEssentialsImporter() {
    }

    @Override
    public String getImporterId() {
        return "kiloessentials";
    }

    @Override
    public void importData(MinecraftServer server) {
        File workingDir = new File(System.getProperty("user.dir"));
        Path data = workingDir.toPath().resolve("essentials").resolve("data");
        File users = data.resolve("users").toFile();
        if (users.exists()) {
            int failed = 0;
            int success = 0;
            for (File file : Objects.requireNonNull(users.listFiles())) {
                UUID uuid = UUID.fromString(file.getName().replace(".dat", ""));
                boolean shouldSave = false;
                try {
                    PlayerData playerData = DataStorage.getOfflinePlayerData(server, uuid);
                    class_2487 tag = class_2507.method_10629((InputStream)new FileInputStream(file), (class_2505)class_2505.method_53898());
                    HashMap<String, Home> homes = new HashMap<String, Home>();
                    class_2487 homesTag = tag.method_68568("homes");
                    for (String key : homesTag.method_10541()) {
                        class_2487 loc = (class_2487)((class_2487)homesTag.method_10562(key).orElseThrow()).method_10562("loc").orElseThrow();
                        class_2487 pos = (class_2487)loc.method_10562("pos").orElseThrow();
                        class_2487 view = (class_2487)loc.method_10562("view").orElseThrow();
                        homes.put(key, new Home(new Location(new class_243(((Double)pos.method_10574("x").orElseThrow()).doubleValue(), ((Double)pos.method_10574("y").orElseThrow()).doubleValue(), ((Double)pos.method_10574("z").orElseThrow()).doubleValue()), ((Float)view.method_10583("yaw").orElseThrow()).floatValue(), ((Float)view.method_10583("pitch").orElseThrow()).floatValue(), class_2960.method_60654((String)((String)loc.method_10558("dim").orElseThrow())))));
                    }
                    if (!homes.isEmpty()) {
                        shouldSave = true;
                        playerData.homes.putAll(homes);
                    }
                    if (shouldSave) {
                        DataStorage.updateOfflinePlayerData(server, uuid, playerData);
                    }
                    ++success;
                }
                catch (Throwable e) {
                    EssentialsMod.LOGGER.error("An error occurred while parsing user file", e);
                    ++failed;
                }
            }
            EssentialsMod.LOGGER.info("User data imported, {} successful, {} failed!", (Object)success, (Object)failed);
        } else {
            EssentialsMod.LOGGER.error("User directory ({}) doesn't exist", (Object)users);
        }
        File warpsFile = data.resolve("warps.dat").toFile();
        if (warpsFile.exists()) {
            try {
                class_2487 tag = class_2507.method_10629((InputStream)new FileInputStream(warpsFile), (class_2505)class_2505.method_53898());
                HashMap<String, Warp> warps = new HashMap<String, Warp>();
                for (String key : tag.method_10541()) {
                    class_2487 loc = (class_2487)((class_2487)tag.method_10562(key).orElseThrow()).method_10562("loc").orElseThrow();
                    class_2487 pos = (class_2487)loc.method_10562("pos").orElseThrow();
                    class_2487 view = (class_2487)loc.method_10562("view").orElseThrow();
                    warps.put(key, new Warp(new Location(new class_243(((Double)pos.method_10574("x").orElseThrow()).doubleValue(), ((Double)pos.method_10574("y").orElseThrow()).doubleValue(), ((Double)pos.method_10574("z").orElseThrow()).doubleValue()), ((Float)view.method_10583("yaw").orElseThrow()).floatValue(), ((Float)view.method_10583("pitch").orElseThrow()).floatValue(), class_2960.method_60654((String)((String)loc.method_10558("dim").orElseThrow())))));
                }
                ServerData serverData = DataStorage.serverData();
                serverData.getWarps().putAll(warps);
                EssentialsMod.LOGGER.info("Warps data imported, imported {} warps!", (Object)warps.size());
            }
            catch (Throwable e) {
                EssentialsMod.LOGGER.error("An error occurred while parsing warps file", e);
            }
        }
    }
}

