/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.warp;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.Executor;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.command.util.CommandUtil;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.util.teleportation.Warp;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class WarpCommand
extends Command {
    public static final SimpleCommandExceptionType UNKNOWN = new SimpleCommandExceptionType((Message)LocalizedMessage.localized((String)"fabric-essentials.commands.warp.unknown"));
    public static final SuggestionProvider<class_2168> WARPS_PROVIDER = (ctx, builder) -> class_2172.method_9265(DataStorage.serverData().getWarps().keySet(), (SuggestionsBuilder)builder);

    public WarpCommand() {
        super(CommandProperties.create("warp", 0));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        RequiredArgumentBuilder name = class_2170.method_9244((String)"warp", (ArgumentType)StringArgumentType.string()).suggests(WARPS_PROVIDER);
        name.executes(this::teleport);
        literal.then((ArgumentBuilder)name);
    }

    private int teleport(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"warp");
        class_3222 serverPlayer = src.method_9207();
        Map<String, Warp> warps = DataStorage.serverData().getWarps();
        Warp warp = warps.get(name);
        if (warp == null) {
            throw UNKNOWN.create();
        }
        class_3218 targetLevel = warp.location().getLevel(src.method_9211());
        if (targetLevel == null) {
            throw WORLD_UNKNOWN.create();
        }
        CommandUtil.asyncTeleport(src, targetLevel, warp.location().chunkPos(), WarpCommand.config().teleportation.waitingPeriod).whenCompleteAsync((chunkAccess, throwable) -> {
            if (chunkAccess == null) {
                return;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> LocalizedMessage.localized((String)"fabric-essentials.commands.warp", warp.placeholders(name)), false);
            warp.location().teleport((class_1297)serverPlayer);
        }, (Executor)src.method_9211());
        return 1;
    }
}

