/*
 * Decompiled with CFR 0.152.
 */
package me.drex.essentials.command.impl.home;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import me.drex.essentials.command.Command;
import me.drex.essentials.command.CommandProperties;
import me.drex.essentials.command.util.CommandUtil;
import me.drex.essentials.config.homes.HomesConfig;
import me.drex.essentials.config.homes.HomesLimit;
import me.drex.essentials.storage.DataStorage;
import me.drex.essentials.storage.PlayerData;
import me.drex.essentials.util.teleportation.Home;
import me.drex.essentials.util.teleportation.Location;
import me.drex.message.api.LocalizedMessage;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class SetHomeCommand
extends Command {
    public SetHomeCommand() {
        super(CommandProperties.create("sethome", 0));
    }

    @Override
    protected void registerArguments(LiteralArgumentBuilder<class_2168> literal, class_7157 commandBuildContext) {
        ((LiteralArgumentBuilder)literal.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"home", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).suggests(CommandUtil.PROFILES_PROVIDER).requires(this.require("other"))).then(class_2170.method_9247((String)"-confirm").executes(ctx -> this.setHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home"), CommandUtil.getGameProfile((CommandContext<class_2168>)ctx, "player"), false, true)))).executes(ctx -> this.setHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home"), CommandUtil.getGameProfile((CommandContext<class_2168>)ctx, "player"), false, false)))).then(class_2170.method_9247((String)"-confirm").executes(ctx -> this.setHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home"), ((class_2168)ctx.getSource()).method_9207().method_7334(), true, true)))).executes(ctx -> this.setHome((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"home"), ((class_2168)ctx.getSource()).method_9207().method_7334(), true, false)))).executes(ctx -> this.setHome((class_2168)ctx.getSource(), "home", ((class_2168)ctx.getSource()).method_9207().method_7334(), true, false));
    }

    protected int setHome(class_2168 src, String name, GameProfile target, boolean self, boolean confirm) {
        boolean overwrite;
        PlayerData playerData = DataStorage.getOfflinePlayerData(src.method_9211(), target);
        Map<String, Home> homes = playerData.homes;
        Home previousHome = homes.get(name);
        if (previousHome != null && !confirm) {
            if (self) {
                src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.sethome.self.confirm", previousHome.placeholders(name)));
            } else {
                src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.sethome.other.confirm", previousHome.placeholders(name), (PlaceholderContext)PlaceholderContext.of((GameProfile)target, (MinecraftServer)src.method_9211())));
            }
            return 0;
        }
        int limit = this.getHomesLimit(src);
        boolean bl = overwrite = confirm && previousHome != null;
        if (homes.size() >= limit && !overwrite) {
            src.method_9213((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.sethome.limit"));
            return 0;
        }
        Home home = new Home(new Location(src));
        homes.put(name, home);
        DataStorage.updateOfflinePlayerData(src.method_9211(), target, playerData);
        if (self) {
            src.method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.sethome.self", home.placeholders(name)));
        } else {
            src.method_45068((class_2561)LocalizedMessage.localized((String)"fabric-essentials.commands.sethome.other", home.placeholders(name), (PlaceholderContext)PlaceholderContext.of((GameProfile)target, (MinecraftServer)src.method_9211())));
        }
        return 1;
    }

    private int getHomesLimit(class_2168 src) {
        if (this.check(src, "limit.bypass")) {
            return Integer.MAX_VALUE;
        }
        HomesConfig homesConfig = SetHomeCommand.config().homes;
        int limit = homesConfig.defaultLimit;
        int added = 0;
        for (HomesLimit homesLimit : homesConfig.homesLimits) {
            if (!this.check(src, "limit." + homesLimit.permission)) continue;
            if (homesLimit.stacks) {
                added += homesLimit.limit;
                continue;
            }
            limit = Math.max(limit, homesLimit.limit);
        }
        return limit += added;
    }
}

