/*
 * Decompiled with CFR 0.152.
 */
package de.aliba2468pr77pr77.savedcommands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5218;
import net.minecraft.class_642;

@Environment(value=EnvType.CLIENT)
public class SavedCommandManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path filePath;
    public SavedCommandsData data;

    public SavedCommandManager(String World) {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path myDir = configDir.resolve("savedcommands");
        this.filePath = myDir.resolve(World + ".json");
        this.load();
    }

    public SavedCommandManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path myDir = configDir.resolve("savedcommands");
        this.filePath = myDir.resolve(SavedCommandManager.getWorldOrServerId() + ".json");
        this.load();
    }

    public static String getWorldOrServerId() {
        class_310 client = class_310.method_1551();
        class_1132 integratedServer = client.method_1576();
        if (integratedServer != null) {
            return "singleplayer/" + integratedServer.method_27050(class_5218.field_24188).getParent().getFileName().toString();
        }
        class_642 server = client.method_1558();
        if (server != null) {
            return "multiplayer/" + server.field_3761;
        }
        return "none";
    }

    public synchronized void addCommand(String command, String name) {
        if (command == null || command.isEmpty()) {
            return;
        }
        this.data.commands.add(new CommandData(command, name));
        this.saveAsync();
    }

    public synchronized void removeCommand(int index) {
        if (index >= 0 && index < this.data.commands.size()) {
            this.data.commands.remove(index);
            this.saveAsync();
        }
    }

    private void load() {
        try {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            if (Files.exists(this.filePath, new LinkOption[0])) {
                String json = Files.readString(this.filePath);
                this.data = (SavedCommandsData)GSON.fromJson(json, SavedCommandsData.class);
                if (this.data == null) {
                    this.data = new SavedCommandsData();
                }
            } else {
                this.data = new SavedCommandsData();
                this.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.data = new SavedCommandsData();
        }
    }

    private synchronized void save() {
        try {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this.data);
            Files.writeString(this.filePath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAsync() {
        SavedCommandsData snapshot;
        SavedCommandManager savedCommandManager = this;
        synchronized (savedCommandManager) {
            snapshot = new SavedCommandsData();
            snapshot.commands = new ArrayList<CommandData>(this.data.commands);
        }
        CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
                String json = GSON.toJson((Object)snapshot);
                Files.writeString(this.filePath, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static class SavedCommandsData {
        public List<CommandData> commands = new ArrayList<CommandData>();
    }

    @Environment(value=EnvType.CLIENT)
    public static class CommandData {
        public String command;
        public String name;
        public keybindCombination keybinds;

        CommandData(String command, String name) {
            this.command = command;
            this.name = name;
        }

        @Environment(value=EnvType.CLIENT)
        public static class keybindCombination {
            public List<String> keybindType = new ArrayList<String>();
            public List<Integer> keybindCode = new ArrayList<Integer>();

            public List<class_3675.class_306> toKeys() {
                ArrayList<class_3675.class_306> keybinds = new ArrayList<class_3675.class_306>();
                for (int i = 0; i < this.keybindCode.size(); ++i) {
                    keybinds.add(class_3675.class_307.valueOf((String)this.keybindType.get(i)).method_1447(this.keybindCode.get(i).intValue()));
                }
                return keybinds;
            }

            public boolean isEmptyOrNull() {
                return this.keybindCode == null || this.keybindType == null || this.keybindCode.isEmpty() || this.keybindType.isEmpty();
            }
        }
    }
}

